/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.audit.uri;

import com.atlassian.confluence.api.impl.service.audit.uri.ResourceUriGenerator;
import com.atlassian.confluence.api.impl.service.audit.uri.UriGeneratorHelper;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.core.Addressable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.dmz.ContentEntityManagerInternal;
import com.atlassian.confluence.dmz.pages.PageManagerInternal;
import com.atlassian.confluence.internal.content.DraftUtils;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Draft;
import io.atlassian.fugue.Pair;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageUriGenerator
implements ResourceUriGenerator {
    private static final Logger log = LoggerFactory.getLogger(PageUriGenerator.class);
    private final PageManagerInternal pageManager;
    private final ContentEntityManagerInternal contentEntityManager;

    public PageUriGenerator(PageManagerInternal pageManager, ContentEntityManagerInternal contentEntityManager) {
        this.pageManager = pageManager;
        this.contentEntityManager = contentEntityManager;
    }

    @Override
    public Map<String, URI> generate(URI baseUrl, Set<String> identifiers) {
        Set parsedIds = identifiers.stream().filter(NumberUtils::isParsable).map(Long::valueOf).collect(Collectors.toSet());
        return parsedIds.stream().map(contentId -> this.contentEntityManager.getById(ContentId.of((long)contentId))).filter(Objects::nonNull).map(this::getAddressable).filter(pair -> Objects.nonNull(pair) && Objects.nonNull(pair.right())).collect(Collectors.toMap(pair -> String.valueOf(pair.left()), pair -> UriGeneratorHelper.contentUri(baseUrl, (Addressable)pair.right())));
    }

    private @Nullable Pair<Long, Addressable> getAddressable(ContentEntityObject content) {
        long originalId = content.getId();
        try {
            if (DraftUtils.isPageOrBlogPost((ContentEntityObject)content)) {
                return Pair.pair((Object)originalId, (Object)content);
            }
            if (DraftUtils.isDraft((ContentEntityObject)content) && content.isUnpublished()) {
                return DraftUtils.isPersonalDraft((ContentEntityObject)content) ? Pair.pair((Object)originalId, (Object)content) : null;
            }
            if (DraftUtils.isDraft((ContentEntityObject)content) && !content.isUnpublished()) {
                if (DraftUtils.isPersonalDraft((ContentEntityObject)content)) {
                    Draft publishedPersonalDraft = (Draft)content;
                    return Pair.pair((Object)originalId, (Object)this.pageManager.getAbstractPage(publishedPersonalDraft.getPageIdAsLong().longValue()));
                }
                AbstractPage publishedSharedDraft = (AbstractPage)content;
                return Pair.pair((Object)originalId, (Object)publishedSharedDraft.getOriginalVersionPage());
            }
        }
        catch (Exception e) {
            log.debug("Error generating link for {}", (Object)content, (Object)e);
        }
        return null;
    }
}

