/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.audit;

import com.atlassian.audit.spi.permission.ResourceContextPermissionChecker;
import com.atlassian.confluence.audit.StandardAuditResourceTypes;
import com.atlassian.confluence.dmz.spaces.SpaceManagerInternal;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceResourceContextPermissionChecker
implements ResourceContextPermissionChecker {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceResourceContextPermissionChecker.class);
    private final SpaceManagerInternal spaceManagerInternal;
    private final PermissionManager permissionManager;
    private final StandardAuditResourceTypes auditResourceTypes;

    public ConfluenceResourceContextPermissionChecker(SpaceManagerInternal spaceManagerInternal, PermissionManager permissionManager, StandardAuditResourceTypes auditResourceTypes) {
        this.spaceManagerInternal = Objects.requireNonNull(spaceManagerInternal);
        this.permissionManager = Objects.requireNonNull(permissionManager);
        this.auditResourceTypes = Objects.requireNonNull(auditResourceTypes);
    }

    public boolean hasResourceAuditViewPermission(@NonNull String resourceType, @NonNull String resourceId) {
        long spaceId;
        if (!this.auditResourceTypes.space().equals(resourceType)) {
            return false;
        }
        try {
            spaceId = Long.parseLong(resourceId);
        }
        catch (NumberFormatException nfe) {
            log.warn("Invalid spaceId {}", (Object)resourceId, (Object)nfe);
            return false;
        }
        return this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, (Object)this.spaceManagerInternal.getSpace(spaceId));
    }
}

