/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.audit;

import com.atlassian.audit.core.spi.service.CurrentUserProvider;
import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.RequestCacheThreadLocal;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ConfluenceAuditUserProvider
implements CurrentUserProvider {
    public @NonNull AuditAuthor currentUser() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null) {
            return AuditAuthor.builder().type("user").id(user.getKey().getStringValue()).name(user.getFullName()).build();
        }
        if (RequestCacheThreadLocal.getRemoteAddress() == null) {
            return AuditAuthor.SYSTEM_AUTHOR;
        }
        return AuditAuthor.ANONYMOUS_AUTHOR;
    }
}

