/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands;

import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.event.events.user.UserRemovingEvent;
import com.atlassian.confluence.impl.user.crowd.CrowdDirectoryEntityHelper;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.UserGroupCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserModelType;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.journalmessage.UserJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.model.UserEventModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.usermanagement.UserManagementInSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.internal.api.service.incrementalsync.CommandCreator;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.crowd.CrowdUserDirectoryHelper;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.sal.api.user.UserKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserRemovingEventCommand
implements Command<UserRemovingEvent, UserManagementInSyncModel>,
CommandCreator<UserRemovingEvent, UserManagementInSyncModel> {
    private static final Logger logger = LoggerFactory.getLogger(UserRemovingEventCommand.class);
    private final UserGroupCommandSupport commandSupport;
    private final CrowdUserDirectoryHelper crowdUserDirectoryHelper;
    private final CrowdDirectoryEntityHelper crowdDirectoryEntityHelper;
    private final UserAccessor userAccessor;
    private final MembershipDao membershipDao;

    public UserRemovingEventCommand(UserGroupCommandSupport commandSupport, CrowdUserDirectoryHelper crowdUserDirectoryHelper, CrowdDirectoryEntityHelper crowdDirectoryEntityHelper, UserAccessor userAccessor, MembershipDao membershipDao) {
        this.commandSupport = Objects.requireNonNull(commandSupport);
        this.crowdUserDirectoryHelper = Objects.requireNonNull(crowdUserDirectoryHelper);
        this.crowdDirectoryEntityHelper = Objects.requireNonNull(crowdDirectoryEntityHelper);
        this.userAccessor = Objects.requireNonNull(userAccessor);
        this.membershipDao = Objects.requireNonNull(membershipDao);
    }

    public void processEvent(UserRemovingEvent event, Object ... parameters) {
        com.atlassian.crowd.model.user.User user = event.getUser();
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(user.getName());
        if (confluenceUser == null) {
            logger.warn("ConfluenceUser with username {} not found", (Object)user.getName());
            return;
        }
        String userKey = confluenceUser.getKey().getStringValue();
        if (this.crowdDirectoryEntityHelper.isCanonical((DirectoryEntity)user)) {
            List directories = this.crowdUserDirectoryHelper.getDirectoriesForUser((com.atlassian.user.User)confluenceUser);
            if (directories.size() > 1) {
                if (!this.crowdUserDirectoryHelper.isMembershipAggregationEnabled()) {
                    Directory nextDirectory = this.findNextDirectoryForUnshadowedUser(directories, user);
                    List<String> groupMembershipsToAdd = this.getGroupMembershipsForUser(nextDirectory.getId(), user.getName());
                    groupMembershipsToAdd.forEach(groupName -> this.commandSupport.addGroupMembershipForUser((String)groupName, event.getTimestamp(), userKey));
                }
            } else {
                UserJournalMessage message = new UserJournalMessage(event.getTimestamp(), userKey);
                this.commandSupport.enqueueForUserManagement(String.valueOf((Object)UserJournalEntryTypes.USER_DELETED_ENTRY), message);
            }
            List<String> groupMembershipsToRemove = this.getGroupMembershipsForUser(user.getDirectoryId(), user.getName());
            groupMembershipsToRemove.forEach(groupName -> this.commandSupport.removeGroupMembershipForUser((String)groupName, event.getTimestamp(), userKey));
        } else if (this.crowdUserDirectoryHelper.isMembershipAggregationEnabled()) {
            List<String> groupMembershipsToRemove = this.getGroupMembershipsForUser(user.getDirectoryId(), user.getName());
            groupMembershipsToRemove.forEach(groupName -> this.commandSupport.removeGroupMembershipForUser((String)groupName, event.getTimestamp(), userKey));
        }
    }

    public Collection<UserManagementInSyncModel> processJournalEntries(Collection<JournalEntry> journalEntries) {
        ArrayList<UserManagementInSyncModel> userDeletedModels = new ArrayList<UserManagementInSyncModel>();
        for (JournalEntry journalEntry : journalEntries) {
            UserJournalEntryTypes entryType = UserJournalEntryTypes.valueOf(journalEntry.getType());
            this.commandSupport.deserializeJournalMessage(UserJournalMessage.class, journalEntry).ifPresent(userDeleteJournalMessage -> {
                String userKey = userDeleteJournalMessage.getUserKey();
                UserEventModel userDeletedModel = new UserEventModel(journalEntry.getId(), UserModelType.USER_MANAGEMENT.getName(), entryType.getJsonModelOperation().getName(), (Person)User.fromUserkey((UserKey)new UserKey(userKey)));
                userDeletedModels.add(userDeletedModel);
            });
        }
        return userDeletedModels;
    }

    private List<String> getGroupMembershipsForUser(long directoryId, String username) {
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(username).returningAtMost(-1);
        return this.membershipDao.search(directoryId, membershipQuery);
    }

    public Optional<Command<UserRemovingEvent, UserManagementInSyncModel>> newCommand(UserRemovingEvent event) {
        return Optional.of(new UserRemovingEventCommand(this.commandSupport, this.crowdUserDirectoryHelper, this.crowdDirectoryEntityHelper, this.userAccessor, this.membershipDao));
    }

    public Optional<Command<UserRemovingEvent, UserManagementInSyncModel>> newCommand(JournalEntry journalEntry) {
        if (!UserJournalEntryTypes.USER_DELETED_ENTRY.name().equals(journalEntry.getType())) {
            return Optional.empty();
        }
        return Optional.of(new UserRemovingEventCommand(this.commandSupport, this.crowdUserDirectoryHelper, this.crowdDirectoryEntityHelper, this.userAccessor, this.membershipDao));
    }

    private Directory findNextDirectoryForUnshadowedUser(List<Directory> directories, com.atlassian.crowd.model.user.User user) {
        int nextIndex = 0;
        for (int i = 0; i < directories.size() - 1; ++i) {
            Directory directory = directories.get(i);
            if (directory.getId().longValue() != user.getDirectoryId()) continue;
            nextIndex = i + 1;
            break;
        }
        return directories.get(nextIndex);
    }
}

