/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands;

import com.atlassian.confluence.api.impl.service.content.factory.PersonFactory;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.people.KnownUser;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.impl.user.crowd.CrowdDirectoryEntityHelper;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.JournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.UserGroupCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserModelType;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.journalmessage.GroupMembershipJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.model.GroupMembershipEventModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.usermanagement.UserManagementInSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.internal.api.service.incrementalsync.CommandCreator;
import com.atlassian.confluence.user.crowd.CrowdUserDirectoryHelper;
import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.model.membership.MembershipType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GroupMembershipsEventCommand<T extends DirectoryEvent>
implements Command<T, UserManagementInSyncModel>,
CommandCreator<T, UserManagementInSyncModel> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final UserGroupCommandSupport commandSupport;
    protected final PersonFactory personFactory;
    protected final CrowdDirectoryEntityHelper crowdDirectoryEntityHelper;
    protected final CrowdUserDirectoryHelper crowdUserDirectoryHelper;

    protected GroupMembershipsEventCommand(UserGroupCommandSupport commandSupport, PersonFactory personFactory, CrowdDirectoryEntityHelper crowdDirectoryEntityHelper, CrowdUserDirectoryHelper crowdUserDirectoryHelper) {
        this.commandSupport = commandSupport;
        this.personFactory = personFactory;
        this.crowdDirectoryEntityHelper = crowdDirectoryEntityHelper;
        this.crowdUserDirectoryHelper = crowdUserDirectoryHelper;
    }

    public Collection<UserManagementInSyncModel> processJournalEntries(Collection<JournalEntry> journalEntries) {
        ArrayList<UserManagementInSyncModel> results = new ArrayList<UserManagementInSyncModel>();
        for (JournalEntry journalEntry : journalEntries) {
            Optional<GroupMembershipJournalMessage> groupMembershipJournalMessageOptional = this.commandSupport.deserializeJournalMessage(GroupMembershipJournalMessage.class, journalEntry);
            if (groupMembershipJournalMessageOptional.isEmpty()) {
                this.logger.error("Could not deserialize group journal. Journal id [{}] , message: [{}]", (Object)journalEntry.getJournalId(), (Object)journalEntry.getMessage());
                continue;
            }
            GroupMembershipJournalMessage groupEventJournalMessage = groupMembershipJournalMessageOptional.get();
            UserJournalEntryTypes entryType = UserJournalEntryTypes.valueOf(journalEntry.getType());
            try {
                MembershipType membershipType = Objects.requireNonNull(groupEventJournalMessage.getMembershipType());
                UserModelType modelType = membershipType == MembershipType.GROUP_GROUP ? UserModelType.GROUP_GROUP_MEMBERSHIP_MANAGEMENT : UserModelType.GROUP_USER_MEMBERSHIP_MANAGEMENT;
                if (groupEventJournalMessage.getEntityNames().isEmpty()) continue;
                results.add(new GroupMembershipEventModel(journalEntry.getId(), groupEventJournalMessage.getGroupName(), modelType, entryType.getJsonModelOperation(), groupEventJournalMessage.getEntityNames(), membershipType));
            }
            catch (Exception e) {
                this.logger.error("Could not find group with name [{}]", (Object)groupEventJournalMessage.getGroupName(), (Object)e);
            }
        }
        return results;
    }

    protected List<String> getEntityNames(MembershipType membershipType, Collection<String> originalEntityNames) {
        ArrayList<String> entityNames = new ArrayList<String>();
        if (membershipType == MembershipType.GROUP_USER) {
            originalEntityNames.forEach(entityName -> {
                User user = (User)this.personFactory.forUsernameWithoutProfile((String)entityName);
                if (user instanceof KnownUser) {
                    KnownUser knownUser = (KnownUser)user;
                    entityNames.add(knownUser.getUserKey());
                }
            });
        } else {
            entityNames.addAll(originalEntityNames);
        }
        return entityNames;
    }

    protected abstract JournalMessage buildJournalMessage(T var1);
}

