/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands;

import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.JournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.UserGroupCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands.GroupEventCommand;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.journalmessage.GroupJournalMessage;
import com.atlassian.confluence.internal.api.incrementalsync.model.usermanagement.UserManagementInSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import java.util.Optional;

public class GroupCreatedEventCommand
extends GroupEventCommand<GroupCreatedEvent> {
    public GroupCreatedEventCommand(UserGroupCommandSupport commandSupport) {
        super(commandSupport);
    }

    public void processEvent(GroupCreatedEvent event, Object ... parameters) {
        this.createMessage(event).ifPresent(journalMessage -> this.commandSupport.enqueueForUserManagement(UserJournalEntryTypes.GROUP_CREATED_ENTRY.name(), (JournalMessage)journalMessage));
    }

    public Optional<Command<GroupCreatedEvent, UserManagementInSyncModel>> newCommand(GroupCreatedEvent event) {
        return Optional.of(new GroupCreatedEventCommand(this.commandSupport));
    }

    public Optional<Command<GroupCreatedEvent, UserManagementInSyncModel>> newCommand(JournalEntry journalEntry) {
        return UserJournalEntryTypes.GROUP_CREATED_ENTRY.name().equals(journalEntry.getType()) ? Optional.of(new GroupCreatedEventCommand(this.commandSupport)) : Optional.empty();
    }

    private Optional<JournalMessage> createMessage(GroupCreatedEvent event) {
        return Optional.of(new GroupJournalMessage(event.getTimestamp(), event.getGroup().getName()));
    }
}

