/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands;

import com.atlassian.confluence.api.impl.service.content.factory.PersonFactory;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.people.KnownUser;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.people.UnknownUser;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.UserGroupCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserModelType;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.journalmessage.UserJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.model.UserEventModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.usermanagement.UserManagementInSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.internal.api.service.incrementalsync.CommandCreator;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.model.user.User;
import com.atlassian.sal.api.user.UserKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdUserCreatedCommand
implements Command<UserCreatedEvent, UserManagementInSyncModel>,
CommandCreator<UserCreatedEvent, UserManagementInSyncModel> {
    private static final Logger logger = LoggerFactory.getLogger(CrowdUserCreatedCommand.class);
    private final PersonFactory personFactory;
    private final UserGroupCommandSupport commandSupport;

    public CrowdUserCreatedCommand(UserGroupCommandSupport commandSupport, PersonFactory personFactory) {
        this.commandSupport = commandSupport;
        this.personFactory = personFactory;
    }

    public void processEvent(UserCreatedEvent event, Object ... parameters) {
        User user = event.getUser();
        Person person = this.personFactory.forUsernameWithoutProfile(user.getName());
        if (!(person instanceof KnownUser)) {
            logger.warn("User {} is unknown", (Object)user.getName());
            return;
        }
        String userKey = person.optionalUserKey().orElse(new UserKey("")).getStringValue();
        UserJournalMessage message = new UserJournalMessage(event.getTimestamp(), userKey);
        this.commandSupport.enqueueForUserManagement(String.valueOf((Object)UserJournalEntryTypes.USER_CREATED_ENTRY), message);
    }

    public Collection<UserManagementInSyncModel> processJournalEntries(Collection<JournalEntry> journalEntries) {
        ArrayList<UserManagementInSyncModel> result = new ArrayList<UserManagementInSyncModel>();
        for (JournalEntry journalEntry : journalEntries) {
            UserJournalEntryTypes entryType = UserJournalEntryTypes.valueOf(journalEntry.getType());
            this.commandSupport.deserializeJournalMessage(UserJournalMessage.class, journalEntry).ifPresent(userJournalMessage -> {
                String userKey = userJournalMessage.getUserKey();
                Person person = this.personFactory.forUserKey(userKey, Expansions.of((String[])new String[]{"status"}));
                if (person instanceof UnknownUser) {
                    logger.warn("Could not find user with user key {}. ", (Object)userKey);
                    return;
                }
                result.add(new UserEventModel(journalEntry.getId(), UserModelType.USER_MANAGEMENT.getName(), entryType.getJsonModelOperation().getName(), person));
            });
        }
        return result;
    }

    public Optional<Command<UserCreatedEvent, UserManagementInSyncModel>> newCommand(UserCreatedEvent event) {
        return Optional.of(new CrowdUserCreatedCommand(this.commandSupport, this.personFactory));
    }

    public Optional<Command<UserCreatedEvent, UserManagementInSyncModel>> newCommand(JournalEntry journalEntry) {
        if (!UserJournalEntryTypes.USER_CREATED_ENTRY.name().equals(journalEntry.getType())) {
            return Optional.empty();
        }
        return Optional.of(new CrowdUserCreatedCommand(this.commandSupport, this.personFactory));
    }
}

