/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.globalpermissionmanagement.journalmessage;

import com.atlassian.confluence.internal.api.impl.service.incrementalsync.JournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.globalpermissionmanagement.GlobalPermissionModelType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class GlobalPermissionJournalMessage
implements JournalMessage {
    @JsonProperty
    private String permissionType;
    @JsonProperty
    private GlobalPermissionModelType subjectType;
    @JsonProperty
    private String subject;

    public GlobalPermissionJournalMessage(@JsonProperty(value="permissionType") String permissionType, @JsonProperty(value="subjectType") GlobalPermissionModelType subjectType, @JsonProperty(value="subject") String subject) {
        this.permissionType = permissionType;
        this.subjectType = subjectType;
        this.subject = subject;
    }

    public String getPermissionType() {
        return this.permissionType;
    }

    public GlobalPermissionModelType getSubjectType() {
        return this.subjectType;
    }

    public String getSubject() {
        return this.subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalPermissionJournalMessage that = (GlobalPermissionJournalMessage)o;
        return Objects.equals(this.permissionType, that.permissionType) && this.subjectType == that.subjectType && Objects.equals(this.subject, that.subject);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.permissionType, this.subjectType, this.subject});
    }

    public static GlobalPermissionJournalMessage createUserPermission(String permissionType, String userKey) {
        return new GlobalPermissionJournalMessage(permissionType, GlobalPermissionModelType.USER, userKey);
    }

    public static GlobalPermissionJournalMessage createGroupPermission(String permissionType, String groupName) {
        return new GlobalPermissionJournalMessage(permissionType, GlobalPermissionModelType.GROUP, groupName);
    }

    public static GlobalPermissionJournalMessage createAnonymousPermission(String permissionType) {
        return new GlobalPermissionJournalMessage(permissionType, GlobalPermissionModelType.ANONYMOUS, null);
    }

    public static GlobalPermissionJournalMessage createUnlicensedPermission(String permissionType) {
        return new GlobalPermissionJournalMessage(permissionType, GlobalPermissionModelType.UNLICENSED, null);
    }
}

