/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.commands;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentCreateEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentEvent;
import com.atlassian.confluence.event.events.content.attachment.GeneralAttachmentRestoreEvent;
import com.atlassian.confluence.event.events.content.attachment.HiddenAttachmentRestoreEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRestoreEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageRestoreEvent;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.ContentCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.JournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentExpansions;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentModelType;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.commands.ContentManagementMultiEventsCommand;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.journalmessage.ContentJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.model.ContentModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.contentmanagement.ContentManagementIncSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.util.ObjectMapperProvider;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ContentCreateCommand
extends ContentManagementMultiEventsCommand<ContentEvent> {
    private final ContentService contentService;
    protected final ObjectMapper objectMapper;

    public ContentCreateCommand(ContentCommandSupport commandSupport, ContentService contentService) {
        super(commandSupport);
        this.contentService = contentService;
        this.objectMapper = new ObjectMapperProvider().getObjectMapper();
    }

    @Override
    protected Map<Class<? extends ContentEvent>, ContentJournalEntryTypes> getSupportedEventEntryTypesMap() {
        return Map.of(AttachmentCreateEvent.class, ContentJournalEntryTypes.CONTENT_CREATED_ENTRY, BlogPostCreateEvent.class, ContentJournalEntryTypes.CONTENT_CREATED_ENTRY, BlogPostRestoreEvent.class, ContentJournalEntryTypes.CONTENT_RESTORED_ENTRY, CommentCreateEvent.class, ContentJournalEntryTypes.CONTENT_CREATED_ENTRY, GeneralAttachmentRestoreEvent.class, ContentJournalEntryTypes.CONTENT_RESTORED_ENTRY, PageCreateEvent.class, ContentJournalEntryTypes.CONTENT_CREATED_ENTRY, PageRestoreEvent.class, ContentJournalEntryTypes.CONTENT_RESTORED_ENTRY);
    }

    @Override
    protected List<JournalMessage> createMessages(ContentEvent event) {
        if (event instanceof PageCreateEvent || event instanceof PageRestoreEvent) {
            Page page = ((PageEvent)event).getPage();
            return this.createJournalMessagesFor((ContentEntityObject)page);
        }
        if (event instanceof BlogPostCreateEvent || event instanceof BlogPostRestoreEvent) {
            BlogPost blogPost = ((BlogPostEvent)event).getBlogPost();
            return this.createJournalMessagesFor((ContentEntityObject)blogPost);
        }
        if (event instanceof CommentCreateEvent) {
            CommentCreateEvent commentCreateEvent = (CommentCreateEvent)event;
            Comment comment = commentCreateEvent.getComment();
            return List.of(new ContentJournalMessage(Instant.now().toEpochMilli(), comment.getId(), ContentType.COMMENT));
        }
        if (event instanceof AttachmentEvent) {
            AttachmentEvent attachmentEvent = (AttachmentEvent)event;
            if (event instanceof HiddenAttachmentRestoreEvent) {
                return Collections.emptyList();
            }
            if (event instanceof AttachmentCreateEvent || event instanceof GeneralAttachmentRestoreEvent) {
                Attachment attachment = attachmentEvent.getAttachment();
                return List.of(new ContentJournalMessage(Instant.now().toEpochMilli(), attachment.getId(), ContentType.ATTACHMENT));
            }
        }
        return Collections.emptyList();
    }

    private List<JournalMessage> createJournalMessagesFor(ContentEntityObject ceo) {
        ArrayList relatedContents = new ArrayList();
        if (ceo.getComments() != null && !ceo.getComments().isEmpty()) {
            relatedContents.addAll(ceo.getComments());
        }
        if (ceo.getAttachments() != null && !ceo.getAttachments().isEmpty()) {
            relatedContents.addAll(ceo.getAttachments());
        }
        return this.restoreWithRelatedContentMessages(ceo, Instant.now().toEpochMilli(), relatedContents);
    }

    public Collection<ContentManagementIncSyncModel> processJournalEntries(Collection<JournalEntry> journalEntries) {
        HashMap<ContentId, JournalEntry> contentIdToJournalEntry = new HashMap<ContentId, JournalEntry>();
        HashMap<ContentId, ContentJournalMessage> idContentJournalMessageMap = new HashMap<ContentId, ContentJournalMessage>();
        for (JournalEntry journalEntry : journalEntries) {
            try {
                ContentJournalMessage journalMessage = (ContentJournalMessage)this.objectMapper.readerFor(ContentJournalMessage.class).readValue(journalEntry.getMessage());
                contentIdToJournalEntry.put(ContentId.of((long)journalMessage.getContentId()), journalEntry);
                idContentJournalMessageMap.put(ContentId.of((long)journalMessage.getContentId()), journalMessage);
            }
            catch (JsonProcessingException e) {
                this.logger.debug("Could not deserialize journal with id [{}], type [{}] and message [{}]", new Object[]{journalEntry.getJournalId(), journalEntry.getType(), journalEntry.getMessage()});
            }
        }
        Set contentIds = idContentJournalMessageMap.keySet();
        PageResponse contentResponse = this.contentService.find(ContentExpansions.defaultExpansions()).withId(contentIds).fetchManyWithAnyType((PageRequest)new SimplePageRequest(LimitedRequestImpl.create((int)contentIds.size())));
        return contentResponse.getResults().stream().map(content -> {
            JournalEntry journalEntry = (JournalEntry)contentIdToJournalEntry.get(content.getId());
            ContentJournalEntryTypes entryType = ContentJournalEntryTypes.valueOf(journalEntry.getType());
            Content updatedContent = !content.getAncestors().isEmpty() ? this.buildContentWithDirectAncestor((Content)content) : content;
            return new ContentModel(journalEntry.getId(), ContentModelType.CONTENT_MANAGEMENT_CONTENT.getName(), entryType.getJsonModelOperation().getName(), updatedContent);
        }).toList();
    }

    public Optional<Command<ContentEvent, ContentManagementIncSyncModel>> newCommand(ContentEvent event) {
        return this.getSupportedEventEntryTypesMap().containsKey(event.getClass()) ? Optional.of(new ContentCreateCommand(this.commandSupport, this.contentService)) : Optional.empty();
    }

    public Optional<Command<ContentEvent, ContentManagementIncSyncModel>> newCommand(JournalEntry journalEntry) {
        return super.newCommand(journalEntry, new ContentCreateCommand(this.commandSupport, this.contentService));
    }

    private List<JournalMessage> restoreWithRelatedContentMessages(ContentEntityObject content, long timestamp, List<? extends ContentEntityObject> relatedContents) {
        return this.withRelatedContentMessages(content, timestamp, relatedContents, true);
    }
}

