/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync;

import com.atlassian.confluence.internal.api.impl.service.incrementalsync.CommandFactoryImpl;
import com.atlassian.confluence.internal.api.incrementalsync.model.ContentCommandFactory;
import com.atlassian.confluence.internal.api.incrementalsync.model.contentmanagement.ContentManagementIncSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.CommandCreator;
import com.atlassian.confluence.plugin.descriptor.CommandCreatorModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentCommandFactoryImpl
extends CommandFactoryImpl<ContentManagementIncSyncModel>
implements ContentCommandFactory {
    private static final Logger log = LoggerFactory.getLogger(ContentCommandFactoryImpl.class);
    private final PluginAccessor pluginAccessor;
    private Collection<CommandCreator<?, ContentManagementIncSyncModel>> pluginCommandCreators;

    public ContentCommandFactoryImpl(PluginAccessor pluginAccessor, Collection<CommandCreator<?, ContentManagementIncSyncModel>> commandCreators) {
        super(commandCreators);
        this.pluginAccessor = Objects.requireNonNull(pluginAccessor);
    }

    @Override
    protected Collection<CommandCreator<?, ContentManagementIncSyncModel>> getCommandCreators() {
        return Stream.concat(super.getCommandCreators().stream(), this.getPluginCommandCreators().stream()).toList();
    }

    private Collection<CommandCreator<?, ContentManagementIncSyncModel>> getPluginCommandCreators() {
        if (this.pluginCommandCreators == null) {
            this.reloadPluginCommandCreators();
        }
        return this.pluginCommandCreators;
    }

    public void resetPluginCommandCreators() {
        this.pluginCommandCreators = null;
    }

    public void reloadPluginCommandCreators() {
        log.debug("Reloading plugin command creators");
        this.pluginCommandCreators = this.pluginAccessor.getEnabledModuleDescriptorsByClass(CommandCreatorModuleDescriptor.class).stream().map(ModuleDescriptor::getModule).collect(Collectors.toList());
    }
}

