/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync;

import com.atlassian.confluence.internal.api.incrementalsync.model.CommandFactory;
import com.atlassian.confluence.internal.api.service.incrementalsync.IncrementalSyncService;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecorder {
    private static Logger logger = LoggerFactory.getLogger(AbstractRecorder.class);
    private final TransactionTemplate transactionTemplate;
    private final CommandFactory<?> commandFactory;

    protected AbstractRecorder(TransactionTemplate transactionTemplate, CommandFactory<?> commandFactory) {
        this.transactionTemplate = transactionTemplate;
        this.commandFactory = commandFactory;
    }

    protected <T> void handleEvent(Class<?> eventClass, T event) {
        try {
            this.executeWithTransaction(() -> this.executeCommand(this.commandFactory, eventClass, event));
        }
        catch (Exception ex) {
            logger.error("Failed to handle event {} for user management incremental sync", event, (Object)ex);
        }
    }

    protected <T> void executeCommand(CommandFactory<?> commandFactory, Class<?> eventClass, T event) {
        this.getIncrementalSyncService().handleEventForSubscription(event, journalIdentifier -> commandFactory.createCommand(eventClass, event).ifPresent(command -> command.processEvent(event, new Object[0])));
    }

    protected abstract IncrementalSyncService<?, ?> getIncrementalSyncService();

    private void executeWithTransaction(Runnable runnable) {
        this.transactionTemplate.execute(() -> {
            runnable.run();
            return null;
        });
    }
}

