/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.api.model.pagination.Cursor;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.dmz.security.delegate.ScopesRequestCacheDelegate;
import com.atlassian.confluence.impl.journal.JournalEntry;
import com.atlassian.confluence.impl.journal.JournalServiceInternal;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.IncrementalSyncDataFetcher;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.IncrementalSynchronisationNotAvailable;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal.MultiSubscriptionPerJournalIdentifier;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal.SubscriptionJournalStateStore;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.utils.IncrementalSyncUtil;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncCursor;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncPageResponse;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionId;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionSpec;
import com.atlassian.confluence.internal.api.service.incrementalsync.IncrementalSyncCleaner;
import com.atlassian.confluence.internal.api.service.incrementalsync.IncrementalSyncService;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.util.Clock;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIncrementalSyncService<S extends SubscriptionSpec, T extends IncrementalSyncModel>
implements IncrementalSyncService<S, T>,
IncrementalSyncCleaner {
    private static final String SUBSCRIPTION_NOT_FOUND_MESSAGE = "Subscription with ID %s was not found or has been deactivated";
    @VisibleForTesting
    public static final String INCREMENTAL_SYNC_EVENTS_BATCH_LIMIT_PREFIX = "confluence.incremental.sync.events.batch.limit.";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final PermissionManager permissionManager;
    protected final JournalServiceInternal journalService;
    protected final Clock clock;
    protected final SubscriptionJournalStateStore subscriptionJournalStateStore;
    protected final IncrementalSyncDataFetcher<T> incrementalSyncDataFetcher;
    protected final ScopesRequestCacheDelegate scopesRequestCacheDelegate;

    protected AbstractIncrementalSyncService(JournalServiceInternal journalService, SubscriptionJournalStateStore subscriptionJournalStateStore, Clock clock, PermissionManager permissionManager, IncrementalSyncDataFetcher<T> incrementalSyncDataFetcher, ScopesRequestCacheDelegate scopesRequestCacheDelegate) {
        this.journalService = Objects.requireNonNull(journalService);
        this.subscriptionJournalStateStore = Objects.requireNonNull(subscriptionJournalStateStore);
        this.clock = Objects.requireNonNull(clock);
        this.permissionManager = Objects.requireNonNull(permissionManager);
        this.incrementalSyncDataFetcher = Objects.requireNonNull(incrementalSyncDataFetcher);
        this.scopesRequestCacheDelegate = Objects.requireNonNull(scopesRequestCacheDelegate);
    }

    public SubscriptionId subscribe(S spec) {
        this.verifyAdminUserOrManageSubscriptionScope();
        SubscriptionId subscriptionId = this.subscriptionJournalStateStore.createNewSubscription(this.getSubscriptionData(spec));
        return SubscriptionId.of((IncrementalSyncCursor)this.getMostRecentCursor(subscriptionId.getValue()));
    }

    public boolean unsubscribe(SubscriptionId subscriptionId) {
        this.verifyAdminUserOrManageSubscriptionScope();
        if (!this.isSubscriptionActive(subscriptionId.getValue())) {
            throw new NotFoundException(String.format(SUBSCRIPTION_NOT_FOUND_MESSAGE, subscriptionId.getValue()));
        }
        this.subscriptionJournalStateStore.deactivateSubscription(this.getJournalIdentifier(subscriptionId.getValue()));
        return true;
    }

    public List<SubscriptionId> getAvailableSubscriptions() {
        this.verifyAdminUserOrReadAllScope();
        return this.subscriptionJournalStateStore.getAvailableSubscriptions();
    }

    public void cleanUpSubscriptions() {
        this.getManagedJournalIdentifier().forEach(identifier -> {
            long ttl = IncrementalSyncUtil.getTtlForInactiveSubscriptionInMilliSeconds();
            this.logger.info("Cleaning expired subscription for journal name {} with ttl {}", (Object)identifier.getJournalName(), (Object)ttl);
            this.subscriptionJournalStateStore.cleanUpSubscriptions((JournalIdentifier)identifier, ttl);
        });
    }

    public IncrementalSyncPageResponse<T> processEvents(PageRequest pageRequest) {
        this.verifyAdminUserOrReadAllScope();
        this.verifyBatchLimit(pageRequest);
        Cursor cursor = pageRequest.getCursor();
        if (!(cursor instanceof IncrementalSyncCursor)) {
            throw new BadRequestException("Invalid cursor format. Please use cursor that was provided during subscription.");
        }
        IncrementalSyncCursor incrementalSyncCursor = (IncrementalSyncCursor)cursor;
        long subscriptionId = incrementalSyncCursor.getSubscriptionId();
        if (!this.isSubscriptionActive(subscriptionId)) {
            throw new BadRequestException(String.format(SUBSCRIPTION_NOT_FOUND_MESSAGE, subscriptionId));
        }
        PageResponse<T> result = this.incrementalSyncDataFetcher.getEvents(pageRequest);
        IncrementalSyncPageResponse.Builder responseBuilder = IncrementalSyncPageResponse.builder().setPageRequest(result.getPageRequest()).setNextCursor(result.getNextCursor());
        if (result.getResults().stream().anyMatch(IncrementalSynchronisationNotAvailable.class::isInstance)) {
            responseBuilder.setResults(Collections.emptyList()).setHasMore(false).setIncrementalSynchronisationAvailable(false);
        } else {
            responseBuilder.setResults(result.getResults()).setHasMore(result.hasMore()).setIncrementalSynchronisationAvailable(true);
        }
        return responseBuilder.build();
    }

    protected abstract String getSubscriptionData(S var1);

    protected abstract String getJournalName();

    protected abstract MultiSubscriptionPerJournalIdentifier getJournalIdentifier(long var1);

    protected void verifyAdminUserOrReadAllScope() {
        ConfluenceUser loggedInUser = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.isConfluenceAdministrator(loggedInUser) && !this.scopesRequestCacheDelegate.isScopePermitted("READ_ALL")) {
            throw new PermissionException(String.format("User [%s] doesn't have permissions to perform this operation", loggedInUser == null ? "Anonymous" : loggedInUser.getName()));
        }
    }

    protected void verifyAdminUserOrManageSubscriptionScope() {
        ConfluenceUser loggedInUser = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.isConfluenceAdministrator(loggedInUser) && !this.scopesRequestCacheDelegate.isScopePermitted("MANAGE_SUBSCRIPTIONS")) {
            throw new PermissionException(String.format("User [%s] doesn't have permissions to perform this operation", loggedInUser == null ? "Anonymous" : loggedInUser.getName()));
        }
    }

    private void verifyBatchLimit(PageRequest pageRequest) {
        int batchLimit = this.getEventsBatchLimit();
        if (pageRequest.getLimit() > batchLimit) {
            throw new BadRequestException("The limit (" + pageRequest.getLimit() + ") is higher than the allowed maximum value (" + batchLimit + ")");
        }
    }

    public void cleanObsoleteData() {
        this.logger.info("Cleaning journal entry data");
        long ttl = IncrementalSyncUtil.getTTLForSubscriptionInMilliSeconds();
        this.journalService.removeEntriesOlderThan(new Date(this.clock.getCurrentDate().getTime() - ttl), this.getManagedJournalIdentifier().stream().map(JournalIdentifier::getJournalName).toList());
        this.logger.info("Cleaning deleted and obsolete subscriptions");
        this.cleanUpSubscriptions();
        this.logger.info("Cleaning up completed");
    }

    public boolean isSubscriptionActive(long subscriptionId) {
        return this.subscriptionJournalStateStore.isSubscriptionActive(this.getJournalIdentifier(subscriptionId));
    }

    public IncrementalSyncCursor getMostRecentCursor(long id) {
        if (!this.isSubscriptionActive(id)) {
            throw new NotFoundException(String.format(SUBSCRIPTION_NOT_FOUND_MESSAGE, id));
        }
        Optional journalEntry = this.journalService.getMostRecentId((JournalIdentifier)this.getJournalIdentifier(id));
        long mostRecentId = journalEntry.map(JournalEntry::getId).orElse(0L);
        return new IncrementalSyncCursor(id, mostRecentId);
    }

    public <E> void handleEventForSubscription(E event, Consumer<JournalIdentifier> processor) {
        this.getActiveSubscriptionIdentifier().ifPresent(processor);
    }

    private Optional<MultiSubscriptionPerJournalIdentifier> getActiveSubscriptionIdentifier() {
        return this.subscriptionJournalStateStore.getAvailableSubscriptions().stream().findFirst().map(id -> this.getJournalIdentifier(id.getValue()));
    }
}

