/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.server;

import com.atlassian.confluence.api.model.ServerInformation;
import com.atlassian.confluence.api.service.server.ServerInformationService;
import com.atlassian.confluence.api.service.server.ServerInformationServiceValidator;
import com.atlassian.confluence.setup.BuildInformation;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import java.text.SimpleDateFormat;
import java.util.Locale;

public final class ServerInformationServiceImpl
implements ServerInformationService {
    private final GlobalSettingsManager globalSettingsManager;
    private final ServerInformationServiceValidator validator;

    public ServerInformationServiceImpl(GlobalSettingsManager globalSettingsManager, ServerInformationServiceValidator validator) {
        this.globalSettingsManager = globalSettingsManager;
        this.validator = validator;
    }

    public ServerInformation getServerInformation() {
        this.validator.validateGetServerInformation().throwIfNotSuccessful();
        return this.buildServerInformation();
    }

    private ServerInformation buildServerInformation() {
        return new ServerInformation(this.globalSettingsManager.getGlobalSettings().getBaseUrl(), BuildInformation.INSTANCE.getVersionNumber(), Integer.parseInt(BuildInformation.INSTANCE.getBuildNumber()), Integer.parseInt(BuildInformation.INSTANCE.getMarketplaceBuildNumber()), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.ENGLISH).format(BuildInformation.INSTANCE.getBuildDate()));
    }
}

