/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.permissions;

import com.atlassian.confluence.api.model.messages.Message;
import com.atlassian.confluence.api.model.messages.SimpleMessage;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class SpacePermissionsValidator {
    public ValidationResult validateViewSpacePermissionExistsForUser(Space entitySpace, Collection<SpacePermission> permissionsToAdd, ConfluenceUser user) {
        if (this.viewSpacePermissionWillBeAdded(permissionsToAdd)) {
            return SimpleValidationResult.VALID;
        }
        boolean permissionExist = entitySpace.getPermissions().stream().filter(SpacePermission::isUserPermission).filter(permission -> user.equals(permission.getUserSubject())).anyMatch(permission -> Objects.equals(permission.getType(), "VIEWSPACE"));
        return this.createValidationResult(permissionExist);
    }

    public ValidationResult validateViewSpacePermissionExistsForGroup(Space entitySpace, Collection<SpacePermission> permissionsToAdd, String groupName) {
        if (this.viewSpacePermissionWillBeAdded(permissionsToAdd)) {
            return SimpleValidationResult.VALID;
        }
        boolean permissionExist = entitySpace.getPermissions().stream().filter(SpacePermission::isGroupPermission).filter(permission -> Objects.equals(permission.getGroup(), groupName)).anyMatch(permission -> Objects.equals(permission.getType(), "VIEWSPACE"));
        return this.createValidationResult(permissionExist);
    }

    public ValidationResult validateViewSpacePermissionExistsForAnonymousUser(Space entitySpace, Collection<SpacePermission> permissionsToAdd) {
        if (this.viewSpacePermissionWillBeAdded(permissionsToAdd)) {
            return SimpleValidationResult.VALID;
        }
        boolean permissionExist = entitySpace.getPermissions().stream().filter(SpacePermission::isAnonymousPermission).anyMatch(permission -> Objects.equals(permission.getType(), "VIEWSPACE"));
        return this.createValidationResult(permissionExist);
    }

    public ValidationResult validateAtLeastOneAdminPermissionExists(Space entitySpace, Set<SpacePermission> permissionsToRemove) {
        if (permissionsToRemove.isEmpty()) {
            return SimpleValidationResult.VALID;
        }
        Set existingAdminPermission = entitySpace.getPermissions().stream().filter(perm -> "SETSPACEPERMISSIONS".equals(perm.getType())).collect(Collectors.toSet());
        Set removedAdminPermission = permissionsToRemove.stream().filter(perm -> "SETSPACEPERMISSIONS".equals(perm.getType())).collect(Collectors.toSet());
        return existingAdminPermission.size() > removedAdminPermission.size() ? SimpleValidationResult.VALID : this.createValidationResultWithError("You are not allowed to remove all the Administration Permissions for this space.");
    }

    public ValidationResult validateViewSpacePermissionWillBeAdded(Collection<SpacePermission> permissionsToAdd) {
        return this.createValidationResult(this.viewSpacePermissionWillBeAdded(permissionsToAdd));
    }

    private ValidationResult createValidationResult(boolean permissionExist) {
        return permissionExist ? SimpleValidationResult.VALID : this.createValidationResultWithError("'read space' permission has to exist before adding any other permissions for a user or group. Try adding 'read space' permission for the given user or group.");
    }

    private ValidationResult createValidationResultWithError(String message) {
        return SimpleValidationResult.builder().authorized(true).addMessage((Message)SimpleMessage.withTranslation((String)message)).build();
    }

    private boolean viewSpacePermissionWillBeAdded(Collection<SpacePermission> permissionsToAdd) {
        return permissionsToAdd.stream().anyMatch(spacePermission -> "VIEWSPACE".equals(spacePermission.getType()));
    }
}

