/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.content.typebinding;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.api.impl.service.content.factory.ContentFactory;
import com.atlassian.confluence.api.impl.service.content.typebinding.CommandValidationHelper;
import com.atlassian.confluence.api.impl.service.content.typebinding.TreeSorter;
import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.Container;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentBody;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.pagination.PaginationBatch;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.content.ContentBodyConversionService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.content.apisupport.ApiSupportProvider;
import com.atlassian.confluence.content.apisupport.BaseContentTypeApiSupport;
import com.atlassian.confluence.content.apisupport.CommentExtensionsSupport;
import com.atlassian.confluence.content.service.CommentService;
import com.atlassian.confluence.content.service.comment.CreateCommentCommand;
import com.atlassian.confluence.content.service.comment.EditCommentCommand;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.OperationContext;
import com.atlassian.confluence.core.service.NotAuthorizedException;
import com.atlassian.confluence.core.service.NotValidException;
import com.atlassian.confluence.core.service.ServiceCommand;
import com.atlassian.confluence.dmz.pages.CommentManagerInternal;
import com.atlassian.confluence.dmz.pagination.SubListResponse;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.ContentConvertible;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CommentContentTypeApiSupport
extends BaseContentTypeApiSupport<Comment> {
    private static final Set<ContentType> EXCLUDED_PARENT_TYPES = new HashSet<ContentType>();
    private final CommentManagerInternal commentManager;
    private final PaginationService paginationService;
    private final ContentFactory contentFactory;
    private final PermissionManager permissionManager;
    private final ContentEntityManager contentEntityManager;
    private final CommentService commentService;
    private final ContentBodyConversionService contentBodyConversionService;
    private final PluginAccessor pluginAccessor;
    private final EventPublisher eventPublisher;
    @VisibleForTesting
    static final Function<Comment, @NonNull List<Comment>> ANCESTORS_GETTER = input -> {
        ArrayList<Comment> ancestors = new ArrayList<Comment>();
        while (input.getParent() != null) {
            ancestors.add(0, input.getParent());
            input = input.getParent();
        }
        return ancestors;
    };

    public CommentContentTypeApiSupport(CommentManagerInternal commentManager, PaginationService paginationService, ContentFactory contentFactory, PermissionManager permissionManager, ContentEntityManager contentEntityManager, ApiSupportProvider apiSupportProvider, CommentService commentService, ContentBodyConversionService contentBodyConversionService, PluginAccessor pluginAccessor, EventPublisher eventPublisher) {
        super(apiSupportProvider);
        this.commentManager = commentManager;
        this.paginationService = paginationService;
        this.contentFactory = contentFactory;
        this.permissionManager = permissionManager;
        this.contentEntityManager = contentEntityManager;
        this.commentService = commentService;
        this.contentBodyConversionService = contentBodyConversionService;
        this.pluginAccessor = pluginAccessor;
        this.eventPublisher = eventPublisher;
    }

    public ContentType getHandledType() {
        return ContentType.COMMENT;
    }

    protected PageResponse<Content> getChildrenForThisType(Comment content, LimitedRequest limitedRequest, Expansions expansions, Depth depth) {
        return this.getFilteredChildrenForThisType(content, limitedRequest, expansions, depth, (? super ContentEntityObject t) -> true);
    }

    protected PageResponse<Content> getFilteredChildrenForThisType(Comment content, LimitedRequest limitedRequest, Expansions expansions, Depth depth, Predicate<? super ContentEntityObject> predicate) {
        return this.getChildrenInternal((ContentEntityObject)content, limitedRequest, expansions, depth, predicate);
    }

    public boolean supportsChildrenOfType(ContentType otherType) {
        return !otherType.equals((Object)ContentType.BLOG_POST) && !otherType.equals((Object)ContentType.ATTACHMENT) && !otherType.equals((Object)ContentType.PAGE);
    }

    protected PageResponse<Content> getChildrenOfThisTypeForOtherType(ContentConvertible otherTypeParent, LimitedRequest limitedRequest, Expansions expansions, Depth depth) {
        return this.getFilteredChildrenOfThisTypeForOtherType(otherTypeParent, limitedRequest, expansions, depth, t -> true);
    }

    protected PageResponse<Content> getFilteredChildrenOfThisTypeForOtherType(ContentConvertible otherTypeParent, LimitedRequest limitedRequest, Expansions expansions, Depth depth, Predicate<? super ContentEntityObject> predicate) {
        ContentEntityObject other = this.contentEntityManager.getById(otherTypeParent.getContentId().asLong());
        return this.getChildrenInternal(other, limitedRequest, expansions, depth, predicate);
    }

    private PageResponse<Content> getChildrenInternal(ContentEntityObject parentCeo, LimitedRequest limitedRequest, Expansions expansions, Depth depth, Predicate<? super ContentEntityObject> predicate) {
        if (!this.canView(parentCeo)) {
            return PageResponseImpl.empty((boolean)false);
        }
        PaginationBatch fetchPage = parentCeo instanceof Comment ? nextRequest -> this.commentManager.getFilteredChildren((Comment)parentCeo, nextRequest, depth, predicate) : nextRequest -> {
            if (depth == Depth.ALL) {
                return this.getCommentDescendantsOfContainer(parentCeo, (LimitedRequest)nextRequest, predicate);
            }
            return this.commentManager.getFilteredContainerComments(parentCeo.getId(), nextRequest, depth, predicate);
        };
        return this.paginationService.performPaginationListRequest(limitedRequest, fetchPage, items -> this.contentFactory.buildFrom((Iterable<? extends ContentEntityObject>)items, expansions));
    }

    public boolean supportsChildrenForParentType(ContentType parentType) {
        return !EXCLUDED_PARENT_TYPES.contains(parentType);
    }

    public Map<ContentId, Map<String, Object>> getExtensions(Iterable<Comment> contentEntities, Expansions expansions) {
        HashMap groupByContainerClass = new HashMap();
        contentEntities.forEach(comment -> {
            ContentType type = this.getContentType((Comment)comment);
            groupByContainerClass.computeIfAbsent(type, k -> new ArrayList()).add(comment);
        });
        LinkedHashMap result = new LinkedHashMap();
        List extensionSupports = this.pluginAccessor.getEnabledModulesByClass(CommentExtensionsSupport.class);
        for (CommentExtensionsSupport extensionsSupport : extensionSupports) {
            Stream<Object> entities = Stream.empty();
            for (ContentType type : extensionsSupport.getCommentContainerType()) {
                entities = Stream.concat(entities, Optional.ofNullable((List)groupByContainerClass.get(type)).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull));
            }
            result.putAll(extensionsSupport.getExtensions(entities::iterator, expansions));
        }
        return Collections.unmodifiableMap(result);
    }

    private CommentExtensionsSupport getExtensionSupportForContainerType(ContentType type) {
        List extensionsSupports = this.pluginAccessor.getEnabledModulesByClass(CommentExtensionsSupport.class);
        for (CommentExtensionsSupport extensionsSupport : extensionsSupports) {
            if (!StreamSupport.stream(extensionsSupport.getCommentContainerType().spliterator(), false).anyMatch(t -> Objects.equals(t, type))) continue;
            return extensionsSupport;
        }
        return CommentExtensionsSupport.NULL_OBJECT;
    }

    public Class<Comment> getEntityClass() {
        return Comment.class;
    }

    public Comment create(Content newContent) {
        CreateCommentCommand command = this.newCreateCommentCommand(newContent);
        this.execute((ServiceCommand)command);
        Comment comment = command.getComment();
        ContentEntityObject container = comment.getContainer();
        ContentConvertible convertible = (ContentConvertible)container;
        CommentExtensionsSupport support = this.getExtensionSupportForContainerType(convertible.getContentTypeObject());
        support.updateExtensionsOnEntity(comment, newContent.getExtensions());
        this.eventPublisher.publish((Object)new CommentCreateEvent((Object)this, comment, (OperationContext)DefaultSaveContext.DEFAULT));
        return comment;
    }

    public ValidationResult validateCreate(Content newContent) {
        Container container = newContent.getContainer();
        if (!(container instanceof Content)) {
            return SimpleValidationResult.builder().addError("The container property is required when creating a Comment, and it must be another Content object", new Object[0]).build();
        }
        CreateCommentCommand command = this.newCreateCommentCommand(newContent);
        SimpleValidationResult.Builder validationResultBuilder = CommandValidationHelper.validateCommand((ServiceCommand)command);
        ValidationResult result = this.getExtensionSupportForContainerType(((Content)container).getType()).validateExtensionsForCreate(newContent.getExtensions(), validationResultBuilder);
        return result;
    }

    public ValidationResult validateUpdate(Content updatedContent, Comment existingEntity) {
        ContentEntityObject containerObj = existingEntity.getContainer();
        if (!(containerObj instanceof ContentConvertible)) {
            return SimpleValidationResult.builder().addError("Container must be a ContentConvertible entity" + String.valueOf(containerObj), new Object[0]).build();
        }
        ContentConvertible container = (ContentConvertible)containerObj;
        EditCommentCommand command = this.newEditCommentCommand(updatedContent);
        SimpleValidationResult.Builder validationResultBuilder = CommandValidationHelper.validateCommand((ServiceCommand)command);
        return this.getExtensionSupportForContainerType(container.getContentTypeObject()).validateExtensionsForUpdate(existingEntity, updatedContent.getExtensions(), validationResultBuilder);
    }

    public Comment update(Content contentToUpdate, Comment entity) {
        EditCommentCommand command = this.newEditCommentCommand(contentToUpdate);
        this.execute((ServiceCommand)command);
        Comment comment = command.getComment();
        ContentEntityObject container = comment.getContainer();
        ContentConvertible convertible = (ContentConvertible)container;
        CommentExtensionsSupport support = this.getExtensionSupportForContainerType(convertible.getContentTypeObject());
        support.updateExtensionsOnEntity(comment, contentToUpdate.getExtensions());
        return comment;
    }

    protected void execute(ServiceCommand command) throws PermissionException, BadRequestException {
        try {
            command.execute();
        }
        catch (NotAuthorizedException e) {
            throw new PermissionException((Throwable)e);
        }
        catch (NotValidException e) {
            throw new BadRequestException((Throwable)e);
        }
    }

    private EditCommentCommand newEditCommentCommand(Content newContent) throws ServiceException {
        long commentId = newContent.getId().asLong();
        Map bodyMap = newContent.getBody();
        if (bodyMap.containsKey(ContentRepresentation.STORAGE)) {
            String content = ((ContentBody)bodyMap.get(ContentRepresentation.STORAGE)).getValue();
            return this.commentService.newEditCommentCommand(commentId, content);
        }
        if (bodyMap.containsKey(ContentRepresentation.EDITOR)) {
            String content = ((ContentBody)bodyMap.get(ContentRepresentation.EDITOR)).getValue();
            return this.commentService.newEditCommentFromEditorCommand(commentId, content);
        }
        if (bodyMap.containsKey(ContentRepresentation.WIKI)) {
            String content = this.contentBodyConversionService.convert((ContentBody)bodyMap.get(ContentRepresentation.WIKI), ContentRepresentation.STORAGE).getValue();
            return this.commentService.newEditCommentCommand(commentId, content);
        }
        throw new BadRequestException("Comment to edit must include EDITOR or STORAGE content body.");
    }

    private CreateCommentCommand newCreateCommentCommand(Content newContent) throws ServiceException {
        long parentId = ((Content)newContent.getContainer()).getId().asLong();
        ContentId parentCommentId = newContent.getParentId();
        Map bodyMap = newContent.getBody();
        if (bodyMap.containsKey(ContentRepresentation.STORAGE)) {
            String content = ((ContentBody)bodyMap.get(ContentRepresentation.STORAGE)).getValue();
            return this.commentService.newCreateCommentCommand(parentId, parentCommentId.asLong(), content, UUID.randomUUID());
        }
        if (bodyMap.containsKey(ContentRepresentation.EDITOR)) {
            String content = ((ContentBody)bodyMap.get(ContentRepresentation.EDITOR)).getValue();
            return this.commentService.newCreateCommentFromEditorCommand(parentId, parentCommentId.asLong(), content, UUID.randomUUID());
        }
        if (bodyMap.containsKey(ContentRepresentation.WIKI)) {
            String content = this.contentBodyConversionService.convert((ContentBody)bodyMap.get(ContentRepresentation.WIKI), ContentRepresentation.STORAGE).getValue();
            return this.commentService.newCreateCommentCommand(parentId, parentCommentId.asLong(), content, UUID.randomUUID());
        }
        throw new BadRequestException("Comment to create must include EDITOR or STORAGE content body.");
    }

    private PageResponse<Comment> getCommentDescendantsOfContainer(ContentEntityObject parentCeo, LimitedRequest nextRequest, Predicate<? super ContentEntityObject> predicate) {
        List allComments = parentCeo.getComments();
        List<Comment> creationDateSortedComments = this.filterComments(allComments, predicate);
        Comparator<Comment> commentComparator = Comparator.comparing(o -> o.getCreationDate()).thenComparing(Comment::getContentId);
        List<Comment> treeSortedComments = TreeSorter.depthFirstPreOrdered(creationDateSortedComments, ANCESTORS_GETTER, commentComparator);
        return SubListResponse.from(treeSortedComments, (LimitedRequest)nextRequest);
    }

    private List<Comment> filterComments(List<Comment> comments, Predicate<? super ContentEntityObject> predicate) {
        if (predicate == null) {
            return comments;
        }
        return Collections.unmodifiableList(comments.stream().filter(predicate).collect(Collectors.toList()));
    }

    private boolean canView(ContentEntityObject entity) {
        return this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)entity);
    }

    private ContentType getContentType(Comment input) {
        ContentEntityObject container;
        if (input == null) {
            return null;
        }
        ContentEntityObject contentEntityObject = container = input.isLatestVersion() ? input.getContainer() : ((Comment)input.getLatestVersion()).getContainer();
        if (container == null) {
            return null;
        }
        if (container instanceof ContentConvertible) {
            return ((ContentConvertible)container).getContentTypeObject();
        }
        throw new IllegalStateException("Comment must have a content convertible container : " + String.valueOf(container.getClass()));
    }
}

