/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.content.finder;

import com.atlassian.confluence.api.impl.service.content.factory.ContentFactory;
import com.atlassian.confluence.api.impl.service.content.finder.AbstractPageAndBlogFetcher;
import com.atlassian.confluence.api.impl.service.content.finder.ContentFinderImpl;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.pagination.CursorType;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.pagination.PaginationBatch;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.dmz.pages.PageManagerInternal;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.google.common.base.Strings;
import java.util.function.Predicate;

public class PageFetcher
extends AbstractPageAndBlogFetcher {
    public PageFetcher(ContentFinderImpl finder, PaginationService paginationService, PageManagerInternal pageManagerInternal, ContentFactory contentFactory, SpaceManager spaceManager, PermissionManager permissionManager) {
        super(finder, paginationService, pageManagerInternal, contentFactory, spaceManager, permissionManager);
    }

    @Override
    protected void validateCursor(LimitedRequest request) {
        CursorType requestedCursorType = request.getCursor().getCursorType();
        if (requestedCursorType != CursorType.CONTENT) {
            throw new IllegalArgumentException(String.format("Cursor type is incorrect. Received: %s, but %s was expected", request.getCursor().getCursorType(), CursorType.CONTENT));
        }
    }

    @Override
    protected void validateContentType(ContentType contentType) {
        if (!contentType.equals((Object)ContentType.PAGE)) {
            throw new IllegalArgumentException(String.format("Content type %s is not supported in cursor pagination requests", contentType));
        }
    }

    @Override
    public PageResponse<Content> fetch(LimitedRequest request) throws BadRequestException {
        if (this.contentFinder.getContentContainerId() != null) {
            return PageResponseImpl.empty((boolean)false, (LimitedRequest)request);
        }
        if (!Strings.isNullOrEmpty((String)this.contentFinder.getTitle())) {
            if (this.contentFinder.getSpaces().size() == 1) {
                return this.fetchBySpaceAndTitle(ContentType.PAGE, request);
            }
            return this.fetchByTitle(ContentType.PAGE, request);
        }
        if (this.contentFinder.getCreatedDate() != null) {
            return this.fetchByDate(ContentType.PAGE, request);
        }
        if (this.contentFinder.getSpaces().size() == 1) {
            return this.fetchBySpace(ContentType.PAGE, request);
        }
        return this.fetchAllContent(ContentType.PAGE, request);
    }

    private PageResponse<Content> fetchBySpaceAndTitle(ContentType contentType, LimitedRequest request) {
        Space space = this.spaceManager.getSpace(this.contentFinder.getSpaces().get(0).getKey());
        if (space == null) {
            return PageResponseImpl.empty((boolean)false);
        }
        return this.doPaginationRequest(request, (PaginationBatch<? extends AbstractPage>)((PaginationBatch)request1 -> this.pageManager.getFilteredAbstractPages(space, this.contentFinder.getTitle(), this.contentFinder.getStatuses(), request1, new Predicate[]{this.contentFinder.asPredicateWithContentType(contentType)})), this.contentFinder.getExpansions());
    }
}

