/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.content.finder;

import com.atlassian.confluence.api.impl.service.content.factory.ContentFactory;
import com.atlassian.confluence.api.impl.service.content.finder.AbstractContentFinder;
import com.atlassian.confluence.api.impl.service.content.finder.AttachmentFetcher;
import com.atlassian.confluence.api.impl.service.content.finder.BlogPostFetcher;
import com.atlassian.confluence.api.impl.service.content.finder.CommentFetcher;
import com.atlassian.confluence.api.impl.service.content.finder.ContentLocatorFetcher;
import com.atlassian.confluence.api.impl.service.content.finder.FinderPredicates;
import com.atlassian.confluence.api.impl.service.content.finder.PageFetcher;
import com.atlassian.confluence.api.impl.service.content.typebinding.AttachmentContentTypeApiSupport;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.AttachmentContentId;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.locator.ContentLocator;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.persistence.hibernate.CacheMode;
import com.atlassian.confluence.core.persistence.hibernate.SessionCacheModeThreadLocal;
import com.atlassian.confluence.dmz.ContentEntityManagerInternal;
import com.atlassian.confluence.dmz.pages.AttachmentManagerInternal;
import com.atlassian.confluence.dmz.pages.CommentManagerInternal;
import com.atlassian.confluence.dmz.pages.PageManagerInternal;
import com.atlassian.confluence.dmz.service.content.finder.FinderProxyFactory;
import com.atlassian.confluence.event.events.audit.RestrictedPageViewNotPermittedEvent;
import com.atlassian.confluence.internal.api.security.ConfluenceScopesRequestCache;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.rest.v2.api.model.pagination.PaginationLimits;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.Cleanup;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentFinderImpl
extends AbstractContentFinder {
    private static final Logger log = LoggerFactory.getLogger(ContentFinderImpl.class);
    private final ContentFactory contentFactory;
    private final PageManagerInternal pageManager;
    private final SpaceManager spaceManager;
    private final PaginationService paginationService;
    private final ContentEntityManagerInternal contentEntityManager;
    private final AttachmentContentTypeApiSupport attachmentContentTypeBinding;
    private final PermissionManager permissionManager;
    private final FinderProxyFactory finderProxyFactory;
    private final CommentManagerInternal commentManager;
    private final AttachmentManagerInternal attachmentManager;
    private final EventPublisher eventPublisher;
    private final ConfluenceScopesRequestCache confluenceScopesRequestCache;

    ContentFinderImpl(ContentFactory contentFactory, PageManagerInternal pageManager, SpaceManager spaceManager, PaginationService paginationService, AttachmentContentTypeApiSupport attachmentContentTypeBinding, ContentEntityManagerInternal contentEntityManager, PermissionManager permissionManager, FinderProxyFactory finderProxyFactory, CommentManagerInternal commentManager, AttachmentManagerInternal attachmentManager, EventPublisher eventPublisher, ConfluenceScopesRequestCache confluenceScopesRequestCache, Expansion ... expansions) {
        super(expansions);
        this.contentFactory = contentFactory;
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.paginationService = paginationService;
        this.attachmentContentTypeBinding = attachmentContentTypeBinding;
        this.contentEntityManager = contentEntityManager;
        this.permissionManager = permissionManager;
        this.finderProxyFactory = finderProxyFactory;
        this.commentManager = commentManager;
        this.attachmentManager = attachmentManager;
        this.eventPublisher = eventPublisher;
        this.confluenceScopesRequestCache = confluenceScopesRequestCache;
    }

    public ContentService.SingleContentFetcher withLocator(ContentLocator locator) {
        ContentLocatorFetcher locatorFetcher = new ContentLocatorFetcher(locator, this.contentFactory, this.pageManager, new Expansion[0]);
        return (ContentService.SingleContentFetcher)this.finderProxyFactory.createProxy((Object)locatorFetcher, ContentService.SingleContentFetcher.class);
    }

    public Optional<Content> fetch() {
        if (this.getContentId() != null) {
            return this.internalFetchById(this.getContentId(), this.getVersion(), this.getStatuses(), this.expansions);
        }
        for (ContentType type : this.getContentTypes()) {
            try {
                Iterator iterator = this.fetchMany(type, SimplePageRequest.ONE).iterator();
                if (!iterator.hasNext()) continue;
                Content content = (Content)iterator.next();
                return Optional.of(content);
            }
            catch (ServiceException ex) {
                log.debug("Converting exception in fetchMany to option.none()", (Throwable)ex);
            }
        }
        return Optional.empty();
    }

    public PageResponse<Content> fetchManyWithoutCaching(ContentType type, PageRequest request) throws ServiceException {
        try (Cleanup ignored = SessionCacheModeThreadLocal.temporarilySetCacheMode((CacheMode)CacheMode.IGNORE);){
            PageResponse<Content> pageResponse = this.fetchMany(type, request);
            return pageResponse;
        }
    }

    public PageResponse<Content> fetchMany(ContentType type, PageRequest request) throws ServiceException {
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)request, (int)PaginationLimits.content((Expansions)new Expansions(this.expansions)));
        if (!this.getContentIds().isEmpty()) {
            return this.paginationService.performPaginationListRequest(limitedRequest, input -> this.contentEntityManager.getByIdsAndFilters(this.getContentIds(), input, this.asPredicateWithContentType(type).and(FinderPredicates.permissionPredicate(Permission.VIEW, this.permissionManager))), items -> this.contentFactory.buildFrom((Iterable<? extends ContentEntityObject>)items, new Expansions(this.expansions)));
        }
        if (type.equals((Object)ContentType.PAGE)) {
            return this.createPageFetcher().fetch(limitedRequest);
        }
        if (type.equals((Object)ContentType.BLOG_POST)) {
            return this.createBlogPostFetcher().fetch(limitedRequest);
        }
        if (type.equals((Object)ContentType.COMMENT)) {
            return this.createCommentFetcher().fetch(limitedRequest);
        }
        if (type.equals((Object)ContentType.ATTACHMENT)) {
            return this.createAttachmentFetcher().fetch(limitedRequest);
        }
        throw new IllegalArgumentException("Could not fetch content for unrecognized content type " + String.valueOf(type));
    }

    public PageResponse<Content> fetchManyWithAnyType(PageRequest request) throws ServiceException {
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)request, (int)PaginationLimits.content((Expansions)new Expansions(this.expansions)));
        if (!this.getContentIds().isEmpty()) {
            return this.paginationService.performPaginationListRequest(limitedRequest, input -> this.contentEntityManager.getByIdsAndFilters(this.getContentIds(), input, this.asPredicateWithContentTypes(ContentType.BUILT_IN.toArray(new ContentType[0])).and(FinderPredicates.permissionPredicate(Permission.VIEW, this.permissionManager))), items -> this.contentFactory.buildFrom((Iterable<? extends ContentEntityObject>)items, new Expansions(this.expansions)));
        }
        throw new IllegalArgumentException("contentIds must be specified to fetch content with any type");
    }

    private PageFetcher createPageFetcher() {
        return new PageFetcher(this, this.paginationService, this.pageManager, this.contentFactory, this.spaceManager, this.permissionManager);
    }

    private BlogPostFetcher createBlogPostFetcher() {
        return new BlogPostFetcher(this, this.paginationService, this.pageManager, this.contentFactory, this.spaceManager, this.permissionManager);
    }

    private CommentFetcher createCommentFetcher() {
        return new CommentFetcher(this, this.paginationService, this.contentFactory, this.commentManager, this.spaceManager);
    }

    private AttachmentFetcher createAttachmentFetcher() {
        return new AttachmentFetcher(this, this.paginationService, this.contentFactory, this.spaceManager, this.attachmentManager, this.attachmentContentTypeBinding);
    }

    public Map<ContentType, PageResponse<Content>> fetchMappedByContentType(PageRequest request) throws ServiceException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ContentType type : this.getContentTypes()) {
            builder.put((Object)type, this.fetchMany(type, request));
        }
        return builder.build();
    }

    public Optional<Long> getTotalContentCountIfExpand(Supplier<Long> countSupplier) {
        ConfluenceUser loginUser;
        Expansions expansions = this.getExpansions();
        Optional<Long> totalContentCount = Optional.empty();
        if (expansions.canExpand("possibleTotalCount") && (this.permissionManager.isConfluenceAdministrator(loginUser = AuthenticatedUserThreadLocal.get()) || this.confluenceScopesRequestCache.isScopePermitted("READ_ALL"))) {
            totalContentCount = Optional.of(countSupplier.get());
        }
        return totalContentCount;
    }

    private Optional<Content> internalFetchById(ContentId id, int version, List<ContentStatus> statuses, Expansion ... expansions) {
        ConfluenceUser user;
        ContentEntityObject entity;
        ArrayList<ContentStatus> fetchStatuses = new ArrayList<ContentStatus>(statuses);
        if (version >= 1) {
            for (ContentStatus status : fetchStatuses) {
                if (ContentStatus.HISTORICAL.equals((Object)status) || ContentStatus.CURRENT.equals((Object)status)) continue;
                throw new BadRequestException("Only historical content can be fetched by version ('status=" + status.getValue() + "' cannot be used with 'version' parameter)");
            }
            if (!fetchStatuses.contains(ContentStatus.HISTORICAL)) {
                fetchStatuses.add(ContentStatus.HISTORICAL);
            }
            if (!fetchStatuses.contains(ContentStatus.CURRENT)) {
                fetchStatuses.add(ContentStatus.CURRENT);
            }
        } else if (fetchStatuses.contains(ContentStatus.HISTORICAL)) {
            throw new BadRequestException("Cannot fetch historical content without specifying a version");
        }
        if (id instanceof AttachmentContentId) {
            return this.attachmentContentTypeBinding.getById(id, statuses, new Expansions(expansions));
        }
        ContentEntityObject contentEntityObject = entity = Collections.singletonList(ContentStatus.DRAFT).equals(fetchStatuses) ? this.contentEntityManager.findDraftFor(id.asLong()) : this.contentEntityManager.getById(id, version);
        if (entity != null && entity.isDraft() && !this.permissionManager.hasPermission(user = AuthenticatedUserThreadLocal.get(), Permission.EDIT, (Object)entity)) {
            throw new PermissionException("You do not have edit permissions to fetch draft content.");
        }
        return Optional.ofNullable(this.buildContent(entity, fetchStatuses, expansions));
    }

    private Content buildContent(ContentEntityObject entity, List<ContentStatus> statuses, Expansion ... expansions) {
        if (entity == null) {
            return null;
        }
        if (!statuses.isEmpty() && !FinderPredicates.statusPredicate(statuses).test((ContentEntityObject)entity)) {
            return null;
        }
        if (!this.canView(entity)) {
            if (entity instanceof AbstractPage) {
                this.eventPublisher.publish((Object)new RestrictedPageViewNotPermittedEvent((AbstractPage)entity));
            }
            return null;
        }
        if (!this.canEdit(entity) && entity.isDraft()) {
            return null;
        }
        return this.contentFactory.buildFrom(entity, new Expansions(expansions));
    }

    private boolean canView(ContentEntityObject entity) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.permissionManager.hasPermission(user, Permission.VIEW, (Object)entity);
    }

    private boolean canEdit(ContentEntityObject entity) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.permissionManager.hasPermission(user, Permission.EDIT, (Object)entity);
    }
}

