/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.content.finder;

import com.atlassian.confluence.api.impl.service.content.factory.ContentFactory;
import com.atlassian.confluence.api.impl.service.content.finder.ContentFetcher;
import com.atlassian.confluence.api.impl.service.content.finder.ContentFinderImpl;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.pagination.ContentCursor;
import com.atlassian.confluence.api.model.pagination.CursorType;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.pagination.PaginationBatch;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.dmz.pages.PageManagerInternal;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

abstract class AbstractPageAndBlogFetcher
implements ContentFetcher {
    protected final ContentFinderImpl contentFinder;
    protected final PaginationService paginationService;
    protected final PageManagerInternal pageManager;
    protected final ContentFactory contentFactory;
    protected final SpaceManager spaceManager;
    protected final PermissionManager permissionManager;

    public AbstractPageAndBlogFetcher(ContentFinderImpl contentFinder, PaginationService paginationService, PageManagerInternal pageManagerInternal, ContentFactory contentFactory, SpaceManager spaceManager, PermissionManager permissionManager) {
        this.contentFinder = contentFinder;
        this.paginationService = paginationService;
        this.pageManager = pageManagerInternal;
        this.contentFactory = contentFactory;
        this.spaceManager = spaceManager;
        this.permissionManager = permissionManager;
    }

    protected PageResponse<Content> fetchByTitle(ContentType contentType, LimitedRequest request) {
        return this.doPaginationRequest(request, (PaginationBatch<? extends AbstractPage>)((PaginationBatch)input -> this.pageManager.getFilteredAbstractPages(this.contentFinder.getTitle(), this.contentFinder.getStatuses(), input, new Predicate[]{this.contentFinder.asPredicateWithContentType(contentType)})), this.contentFinder.getExpansions());
    }

    protected PageResponse<Content> fetchByDate(ContentType contentType, LimitedRequest request) {
        LocalDate day = this.contentFinder.getCreatedDate();
        ZoneId zone = ZoneId.systemDefault();
        return this.doPaginationRequest(request, (PaginationBatch<? extends AbstractPage>)((PaginationBatch)input -> this.pageManager.getAbstractPages(day, zone, this.contentFinder.getStatuses(), input, new Predicate[]{this.contentFinder.asPredicateWithContentType(contentType)})), this.contentFinder.getExpansions());
    }

    protected PageResponse<Content> fetchBySpace(ContentType contentType, LimitedRequest request) {
        Space space = this.spaceManager.getSpace(this.contentFinder.getSpaces().get(0).getKey());
        if (space == null) {
            return PageResponseImpl.empty((boolean)false);
        }
        Optional<Long> totalContentCount = this.contentFinder.getTotalContentCountIfExpand(() -> this.pageManager.countSpaceContentByContentTypeAndStatus(space, Collections.singletonList(contentType), this.contentFinder.getStatuses()));
        PageResponse<Content> result = request.getCursor() == null ? this.fetchBySpaceWithOffset(contentType, request, space) : this.fetchBySpaceWithCursor(contentType, request, space);
        return PageResponseImpl.from(result, totalContentCount);
    }

    private PageResponse<Content> fetchBySpaceWithOffset(ContentType contentType, LimitedRequest request, Space space) {
        return this.doPaginationRequest(request, (PaginationBatch<? extends AbstractPage>)((PaginationBatch)input -> this.pageManager.getFilteredAbstractPages(space, (List)Lists.newArrayList((Object[])new ContentType[]{contentType}), this.contentFinder.getStatuses(), input, new Predicate[0])), this.contentFinder.getExpansions());
    }

    private PageResponse<Content> fetchBySpaceWithCursor(ContentType contentType, LimitedRequest request, Space space) {
        return this.doPaginationRequestWithCursor(contentType, request, limitedRequest -> this.pageManager.scanFilteredAbstractPages(space, Collections.singletonList(contentType), this.contentFinder.getStatuses(), limitedRequest, new Predicate[0]), this.contentFinder.getExpansions());
    }

    protected PageResponse<Content> fetchAllContent(ContentType contentType, LimitedRequest request) {
        Optional<Long> totalContentCount = this.contentFinder.getTotalContentCountIfExpand(() -> this.pageManager.countContentTypeByAndStatus(Collections.singletonList(contentType), this.contentFinder.getStatuses()));
        PageResponse<Content> result = request.getCursor() == null ? this.fetchAllContentWithOffset(contentType, request) : this.fetchAllContentWithCursor(contentType, request);
        return PageResponseImpl.from(result, totalContentCount);
    }

    private PageResponse<Content> fetchAllContentWithOffset(ContentType contentType, LimitedRequest request) {
        return this.doPaginationRequest(request, (PaginationBatch<? extends AbstractPage>)((PaginationBatch)input -> this.pageManager.getFilteredAbstractPages((List)Lists.newArrayList((Object[])new ContentType[]{contentType}), this.contentFinder.getStatuses(), input, new Predicate[0])), this.contentFinder.getExpansions());
    }

    private PageResponse<Content> fetchAllContentWithCursor(ContentType contentType, LimitedRequest request) {
        return this.doPaginationRequestWithCursor(contentType, request, limitedRequest -> this.pageManager.scanFilteredAbstractPages(Collections.singletonList(contentType), this.contentFinder.getStatuses(), limitedRequest, new Predicate[0]), this.contentFinder.getExpansions());
    }

    protected PageResponse<Content> doPaginationRequest(LimitedRequest request, PaginationBatch<? extends AbstractPage> paginationBatch, Expansions expansions) {
        return this.paginationService.performPaginationListRequest(request, paginationBatch, items -> this.contentFactory.buildFrom((Iterable<? extends ContentEntityObject>)items, expansions));
    }

    private PageResponse<Content> doPaginationRequestWithCursor(ContentType contentType, LimitedRequest request, Function<LimitedRequest, PageResponse<AbstractPage>> visibleContentScanner, Expansions expansions) {
        this.validateCursor(request);
        this.validateContentType(contentType);
        return this.paginationService.performPaginationListRequestWithCursor(request, visibleContentScanner, items -> this.contentFactory.buildFrom((Iterable<? extends ContentEntityObject>)items, expansions), AbstractPageAndBlogFetcher::calculateCursorFromContent);
    }

    private static ContentCursor calculateCursorFromContent(AbstractPage content, boolean isReverse) {
        CursorType cursorType = content instanceof Page ? CursorType.CONTENT : CursorType.BLOG_POST;
        return ContentCursor.createCursor((boolean)isReverse, (long)content.getId(), (CursorType)cursorType);
    }

    protected abstract void validateCursor(LimitedRequest var1);

    protected abstract void validateContentType(ContentType var1);
}

