/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.content.factory;

import com.atlassian.confluence.api.impl.service.content.factory.Fauxpansions;
import com.atlassian.confluence.api.impl.service.content.factory.LabelFactory;
import com.atlassian.confluence.api.impl.service.content.factory.SpaceMetadataFactory;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.reference.BuilderUtils;
import com.atlassian.confluence.api.model.reference.ModelMapBuilder;
import com.atlassian.confluence.rest.v2.api.model.pagination.PaginationLimits;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSpaceMetadataFactory
implements SpaceMetadataFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultSpaceMetadataFactory.class);
    private static final String LABELS_EXPAND = "labels";
    private final LabelFactory labelFactory;

    public DefaultSpaceMetadataFactory(LabelFactory labelFactory) {
        this.labelFactory = labelFactory;
    }

    @Override
    public Map<String, Object> makeMetadata(Space space, Fauxpansions fauxpansions) {
        if (!fauxpansions.canExpand()) {
            return BuilderUtils.collapsedMap();
        }
        ModelMapBuilder metadata = ModelMapBuilder.newExpandedInstance();
        if (!fauxpansions.getSubExpansions().canExpand(LABELS_EXPAND)) {
            metadata.addCollapsedEntry((Object)LABELS_EXPAND);
        } else {
            try {
                List labels;
                if (log.isDebugEnabled()) {
                    log.debug("Building labels metadata for space {}", (Object)space.getKey());
                }
                LimitedRequest limitedRequest = LimitedRequestImpl.create((int)PaginationLimits.labels());
                List list = labels = space.getDescription() != null ? space.getDescription().getVisibleLabels((User)AuthenticatedUserThreadLocal.get()) : Collections.emptyList();
                if (log.isDebugEnabled()) {
                    log.debug("Found {} labels in space {}", (Object)labels.size(), (Object)space.getKey());
                }
                Collections.sort(labels);
                Iterable convertedLabels = this.labelFactory.buildFrom(labels, fauxpansions.getSubExpansions().getSubExpansions(LABELS_EXPAND));
                PageResponseImpl response = PageResponseImpl.from((Iterable)convertedLabels, (labels.size() > limitedRequest.getLimit() ? 1 : 0) != 0).pageRequest(limitedRequest).build();
                metadata.put((Object)LABELS_EXPAND, (Object)response);
            }
            catch (Exception e) {
                log.error("Failed to build labels metadata for space {}", (Object)space.getKey(), (Object)e);
                throw e;
            }
        }
        return metadata.build();
    }
}

