/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.content;

import com.atlassian.confluence.api.impl.service.content.LabelledContentSpaceValidator;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.messages.Message;
import com.atlassian.confluence.api.model.messages.SimpleMessage;
import com.atlassian.confluence.api.model.reference.Collapsed;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.model.validation.ServiceExceptionSupplier;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.dmz.spaces.SpaceManagerInternal;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.UserChecker;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SpaceValidatorImpl
implements SpaceService.Validator {
    private static final String SPACE_NAME_EXCEEDS_MAX_LENGTH_MESSAGE = "Page name cannot exceed 255 characters";
    private static final int MAX_SPACE_NAME_LENGTH = 255;
    private final SpaceManagerInternal spaceManager;
    private final SpacePermissionManager spacePermissionManager;
    private final AccessModeService accessModeService;
    private final PermissionManager permissionManager;
    private final ContentService contentService;
    private final LicenseService licenseService;
    private final UserChecker userChecker;
    private final LabelManager labelManager;
    private final LabelledContentSpaceValidator labelledContentSpaceValidationPredicate;
    private Predicate<Space> canView = new Predicate<Space>(){

        @Override
        public boolean test(@Nullable Space space) {
            return SpaceValidatorImpl.this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)space);
        }

        public String toString() {
            return String.valueOf(AuthenticatedUserThreadLocal.get()) + " CAN VIEW";
        }
    };

    public SpaceValidatorImpl(SpaceManagerInternal spaceManager, SpacePermissionManager spacePermissionManager, AccessModeService accessModeService, PermissionManager permissionManager, ContentService contentService, LicenseService licenseService, UserChecker userChecker, LabelManager labelManager, LabelledContentSpaceValidator labelledContentSpaceValidationPredicate) {
        this.spaceManager = spaceManager;
        this.spacePermissionManager = spacePermissionManager;
        this.accessModeService = accessModeService;
        this.permissionManager = permissionManager;
        this.contentService = contentService;
        this.licenseService = licenseService;
        this.userChecker = userChecker;
        this.labelManager = labelManager;
        this.labelledContentSpaceValidationPredicate = labelledContentSpaceValidationPredicate;
    }

    public ValidationResult validateGet(String spaceKey) {
        Space internalSpace = this.spaceManager.getSpace(spaceKey);
        if (internalSpace == null) {
            return new SimpleValidationResult.Builder().authorized(true).addError("Cannot find space with key: " + spaceKey, new Object[0]).withExceptionSupplier(ServiceExceptionSupplier.notFoundExceptionSupplier()).build();
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.spacePermissionManager.hasPermission("VIEWSPACE", internalSpace, user)) {
            return new SimpleValidationResult.Builder().addError("Not permitted to view space with key: " + spaceKey, new Object[0]).withExceptionSupplier(ServiceExceptionSupplier.permissionExceptionExceptionSupplier()).build();
        }
        return SimpleValidationResult.VALID;
    }

    public ValidationResult validateCreate(com.atlassian.confluence.api.model.content.Space space, boolean isPrivate) {
        if (this.accessModeService.shouldEnforceReadOnlyAccess()) {
            return SimpleValidationResult.NOT_ALLOWED_IN_READ_ONLY_MODE;
        }
        if (this.validateLicense().isNotSuccessful()) {
            return SimpleValidationResult.FORBIDDEN;
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.hasCreatePermission(user, PermissionManager.TARGET_APPLICATION, Space.class)) {
            return SimpleValidationResult.FORBIDDEN;
        }
        String key = space.getKey();
        if (!Space.isValidGlobalSpaceKey((String)key)) {
            return new SimpleValidationResult.Builder().authorized(true).addMessage((Message)SimpleMessage.withTranslation((String)("Invalid space key: " + key))).build();
        }
        if (this.spaceManager.getSpace(key) != null) {
            return new SimpleValidationResult.Builder().authorized(true).addMessage((Message)SimpleMessage.withTranslation((String)("A space already exists with key " + key))).build();
        }
        String name = space.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            return new SimpleValidationResult.Builder().authorized(true).addMessage((Message)SimpleMessage.withTranslation((String)"Name is blank. Cannot create space with no name.")).build();
        }
        if (name.length() > 255) {
            return new SimpleValidationResult.Builder().authorized(true).addMessage((Message)SimpleMessage.withTranslation((String)SPACE_NAME_EXCEEDS_MAX_LENGTH_MESSAGE)).build();
        }
        ValidationResult descriptionResult = this.validateDescription(space);
        if (!descriptionResult.isValid()) {
            return descriptionResult;
        }
        return SimpleValidationResult.VALID;
    }

    public ValidationResult validateUpdate(com.atlassian.confluence.api.model.content.Space space) {
        if (this.accessModeService.shouldEnforceReadOnlyAccess()) {
            return SimpleValidationResult.NOT_ALLOWED_IN_READ_ONLY_MODE;
        }
        if (this.validateLicense().isNotSuccessful()) {
            return SimpleValidationResult.FORBIDDEN;
        }
        String spaceKey = space.getKey();
        Space internalSpace = this.spaceManager.getSpace(spaceKey);
        if (internalSpace == null) {
            return new SimpleValidationResult.Builder().authorized(true).addMessage((Message)SimpleMessage.withTranslation((String)("Unknown space key: " + spaceKey))).build();
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.hasPermission(user, Permission.VIEW, (Object)internalSpace) || !this.permissionManager.hasPermission(user, Permission.ADMINISTER, (Object)internalSpace)) {
            return SimpleValidationResult.FORBIDDEN;
        }
        String name = space.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            return new SimpleValidationResult.Builder().authorized(true).addMessage((Message)SimpleMessage.withTranslation((String)"Name is blank. Cannot update space to have no name.")).build();
        }
        if (name.length() > 255) {
            return new SimpleValidationResult.Builder().authorized(true).addMessage((Message)SimpleMessage.withTranslation((String)SPACE_NAME_EXCEEDS_MAX_LENGTH_MESSAGE)).build();
        }
        ValidationResult descriptionResult = this.validateDescription(space);
        if (!descriptionResult.isValid()) {
            return descriptionResult;
        }
        Reference homepageRef = space.getHomepageRef();
        if (homepageRef.exists() && homepageRef.isExpanded()) {
            ContentId homepageId = ((Content)homepageRef.get()).getId();
            Content newHomepage = (Content)this.contentService.find(new Expansion[]{new Expansion("space")}).withId(homepageId).fetchOrNull();
            if (newHomepage == null) {
                return new SimpleValidationResult.Builder().authorized(true).addMessage((Message)SimpleMessage.withTranslation((String)("Cannot update space homepage to unknown content with id: " + String.valueOf(homepageId)))).build();
            }
            if (!spaceKey.equals(newHomepage.getSpace().getKey())) {
                return new SimpleValidationResult.Builder().authorized(true).addMessage((Message)SimpleMessage.withTranslation((String)("Cannot update space homepage to page in space with key: " + newHomepage.getSpace().getKey()))).build();
            }
        }
        return SimpleValidationResult.VALID;
    }

    private ValidationResult validateDescription(com.atlassian.confluence.api.model.content.Space space) {
        Map description = space.getDescription();
        if (!(description == null || description instanceof Collapsed || description.isEmpty() || description.containsKey(ContentRepresentation.PLAIN))) {
            return new SimpleValidationResult.Builder().authorized(true).addMessage((Message)SimpleMessage.withTranslation((String)"For now, only a space description with PLAIN representation is valid.")).build();
        }
        return SimpleValidationResult.VALID;
    }

    public ValidationResult validateDelete(com.atlassian.confluence.api.model.content.Space space) {
        if (this.accessModeService.shouldEnforceReadOnlyAccess()) {
            return SimpleValidationResult.NOT_ALLOWED_IN_READ_ONLY_MODE;
        }
        String key = space.getKey();
        Space internalSpace = this.spaceManager.getSpace(key);
        if (internalSpace == null) {
            return new SimpleValidationResult.Builder().authorized(true).addMessage((Message)SimpleMessage.withTranslation((String)("Cannot find space with key: " + key))).withExceptionSupplier(ServiceExceptionSupplier.notFoundExceptionSupplier()).build();
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        List<String> permissionTypes = Arrays.asList("VIEWSPACE", "SETSPACEPERMISSIONS");
        if (!this.spacePermissionManager.hasAllPermissions(permissionTypes, internalSpace, user)) {
            return new SimpleValidationResult.Builder().addMessage((Message)SimpleMessage.withTranslation((String)("Not permitted to delete space with key: " + key))).build();
        }
        return SimpleValidationResult.VALID;
    }

    private ValidationResult validateLicense() {
        if (this.licenseService.retrieve().isExpired() || this.userChecker != null && this.userChecker.hasTooManyUsers()) {
            return SimpleValidationResult.FORBIDDEN;
        }
        return SimpleValidationResult.VALID;
    }

    public ValidationResult validateArchive(com.atlassian.confluence.api.model.content.Space space) {
        return this.validateChangeStatus(space);
    }

    public ValidationResult validateRestore(com.atlassian.confluence.api.model.content.Space space) {
        return this.validateChangeStatus(space);
    }

    private ValidationResult validateChangeStatus(com.atlassian.confluence.api.model.content.Space space) {
        if (this.accessModeService.shouldEnforceReadOnlyAccess()) {
            return SimpleValidationResult.NOT_ALLOWED_IN_READ_ONLY_MODE;
        }
        Space internalSpace = this.getInternalSpace(space);
        if (internalSpace == null) {
            return SimpleValidationResult.builder().addMessage((Message)SimpleMessage.withTranslation((String)("A space with key " + space.getKey() + " does not exist or you do not have permission to view it"))).withExceptionSupplier(ServiceExceptionSupplier.notFoundExceptionSupplier()).build();
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.hasPermission(user, Permission.EDIT, (Object)internalSpace)) {
            return SimpleValidationResult.builder().addMessage((Message)SimpleMessage.withTranslation((String)("Not permitted to change status of space with key: " + space.getKey()))).withExceptionSupplier(ServiceExceptionSupplier.permissionExceptionExceptionSupplier()).build();
        }
        return SimpleValidationResult.VALID;
    }

    public ValidationResult validateEmptyTrash(String spaceKey) {
        if (this.accessModeService.shouldEnforceReadOnlyAccess()) {
            return SimpleValidationResult.NOT_ALLOWED_IN_READ_ONLY_MODE;
        }
        Space internalSpace = this.spaceManager.getSpace(spaceKey);
        if (internalSpace == null) {
            return new SimpleValidationResult.Builder().authorized(true).addMessage((Message)SimpleMessage.withTranslation((String)("Unknown space key: " + spaceKey))).withExceptionSupplier(ServiceExceptionSupplier.notFoundExceptionSupplier()).build();
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.hasPermission(user, Permission.ADMINISTER, (Object)internalSpace)) {
            return SimpleValidationResult.FORBIDDEN;
        }
        return SimpleValidationResult.VALID;
    }

    Space getInternalSpace(com.atlassian.confluence.api.model.content.Space space) {
        String key = space.getKey();
        Space internalSpace = this.spaceManager.getSpace(key);
        if (!this.canView.test(internalSpace)) {
            internalSpace = null;
        }
        return internalSpace;
    }

    Predicate<Space> getCanView() {
        return this.canView;
    }

    Predicate<Space> getCanViewContentWithLabels(final @NonNull List<Label> labels) {
        return new Predicate<Space>(){

            @Override
            public boolean test(Space space) {
                return SpaceValidatorImpl.this.labelledContentSpaceValidationPredicate.validate(labels, space);
            }

            public String toString() {
                return String.valueOf(AuthenticatedUserThreadLocal.get()) + " CAN VIEW CONTENT WITH GIVEN LABELS IN SPACE";
            }
        };
    }
}

