package com.atlassian.confluence.compat.plugin.descriptor.web.conditions.accessmode;

import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;

import java.util.Map;

/**
 * This condition checks if the current access mode is READ_WRITE
 * The plugin needs to declare the AccessModeCompatService Spring component
 * <p>Usage:
 * <pre>
 *     &lt;bean id="accessModeCompatService" class="com.atlassian.confluence.compat.api.service.accessmode.impl.DefaultAccessModeCompatService"/&gt;
 * </pre>
 * @since 1.2.0
 */
public class ReadWriteAccessModeCondition implements Condition {
    private final AccessModeCompatService accessModeCompatService;

    public ReadWriteAccessModeCondition(AccessModeCompatService accessModeCompatService) {
        this.accessModeCompatService = accessModeCompatService;
    }

    @Override
    public void init(Map<String, String> params) throws PluginParseException {
        // no-op
    }

    @Override
    public boolean shouldDisplay(Map<String, Object> context) {
        return !accessModeCompatService.isReadOnlyAccessModeEnabled();
    }
}
