package com.atlassian.confluence.compat.setup.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;

import java.io.Reader;
import java.io.Writer;

/**
 *  Internal XStream compatibility class for Confluence 7.9 and prior API.
 */
class XStream111Compat implements XStreamCompat {
    private final XStream xStream;

    XStream111Compat(XStream xStream) {
        this.xStream = xStream;
    }

    @Override
    public String toXML(Object obj) {
        return xStream.toXML(obj);
    }

    @Override
    public void toXML(Object obj, Writer writer) {
        xStream.toXML(obj, writer);
    }

    @Override
    public Object fromXML(String xml) {
        return xStream.fromXML(xml);
    }

    @Override
    public Object fromXML(Reader reader) {
        return xStream.fromXML(reader);
    }

    public XStream getXStream() {
        return xStream;
    }

    @Override
    public void registerConverter(Converter converter, Integer priority) {
        xStream.registerConverter(converter, priority);
    }

    @Override
    public void alias(String name, Class<?> type) {
        xStream.alias(name, type);
    }
}
