/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.cluster.hazelcast.interceptor.authenticator;

import com.atlassian.confluence.impl.cluster.hazelcast.interceptor.authenticator.ClusterAuthenticationResult;
import com.atlassian.confluence.impl.cluster.hazelcast.interceptor.authenticator.ClusterAuthenticator;
import com.atlassian.confluence.impl.cluster.hazelcast.interceptor.authenticator.ClusterJoinManager;
import com.atlassian.confluence.impl.cluster.hazelcast.interceptor.authenticator.ClusterJoinMode;
import com.atlassian.confluence.impl.cluster.hazelcast.interceptor.authenticator.ClusterJoinRequest;
import com.atlassian.confluence.impl.cluster.hazelcast.interceptor.authenticator.NodeConnectionException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClusterJoinManager
implements ClusterJoinManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultClusterJoinManager.class);
    private final ClusterAuthenticator clusterAuthenticator;
    private final boolean isNodeAuthenticationEnabled;

    public DefaultClusterJoinManager(ClusterAuthenticator clusterAuthenticator, boolean enableNodeAuthentication) {
        this.clusterAuthenticator = clusterAuthenticator;
        this.isNodeAuthenticationEnabled = enableNodeAuthentication;
    }

    @Override
    public void accept(@NonNull ClusterJoinRequest request) throws IOException {
        log.info("enableNodeAuthentication : {}", (Object)this.isNodeAuthenticationEnabled);
        log.debug("{}: Authenticating cluster node in accept .... ", (Object)request);
        Preconditions.checkArgument((Objects.requireNonNull(request, "request").getJoinMode() == ClusterJoinMode.ACCEPT ? 1 : 0) != 0, (Object)"Expected accept request");
        this.checkNodeAuthenticationEnabled(request);
    }

    @Override
    public void connect(@NonNull ClusterJoinRequest request) throws IOException {
        log.info("enableNodeAuthentication : {}", (Object)this.isNodeAuthenticationEnabled);
        log.debug("{}: Authenticating cluster node in connect .... ", (Object)request);
        Preconditions.checkArgument((Objects.requireNonNull(request, "request").getJoinMode() == ClusterJoinMode.CONNECT ? 1 : 0) != 0, (Object)"Expected connect request");
        this.checkNodeAuthenticationEnabled(request);
    }

    private void checkNodeAuthenticationEnabled(@NonNull ClusterJoinRequest request) throws IOException {
        if (this.isNodeAuthenticationEnabled) {
            log.debug("{}: Authenticating cluster node", (Object)request);
            ClusterAuthenticationResult authenticationResult = this.clusterAuthenticator.authenticate(request);
            if (!authenticationResult.isSuccessful()) {
                log.warn("{}: Node authentication failed: {} ", (Object)request, (Object)authenticationResult.getMessage());
                throw new NodeConnectionException(authenticationResult.getMessage());
            }
            log.debug("{}: Node authenticated success", (Object)request);
        } else {
            log.debug("{}: Node authentication disabled", (Object)request);
        }
    }
}

