/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.cache.hazelcast.hibernate;

import com.atlassian.annotations.VisibleForTesting;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRegionCacheMaxSizeChangeHelper {
    private static final Logger log = LoggerFactory.getLogger(LocalRegionCacheMaxSizeChangeHelper.class);

    public void setNewMaximum(Object localRegionCache, long newMaxSize) {
        try {
            Object underlyingCache = this.getUnderlyingCache(localRegionCache);
            this.setCacheMaximum(underlyingCache, newMaxSize);
        }
        catch (ReflectiveOperationException e) {
            log.error("Unable to set new cache size for the local region cache " + localRegionCache, (Throwable)e);
        }
    }

    @VisibleForTesting
    long getMaximum(Object localRegionCache) {
        try {
            Object underlyingCache = this.getUnderlyingCache(localRegionCache);
            return this.getCacheMaximum(underlyingCache);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Unable to retrieve max cache size for the local region cache " + localRegionCache, e);
        }
    }

    private Object getUnderlyingCache(Object localRegionCache) throws NoSuchFieldException, IllegalAccessException {
        Class<?> delegateClass = localRegionCache.getClass();
        Field field = delegateClass.getDeclaredField("cache");
        field.setAccessible(true);
        return field.get(localRegionCache);
    }

    private void setCacheMaximum(Object underlyingCache, long newMaxSize) throws ReflectiveOperationException {
        Class<?> clazz = underlyingCache.getClass().getSuperclass();
        Method method = clazz.getDeclaredMethod("setMaximum", Long.TYPE);
        method.setAccessible(true);
        method.invoke(underlyingCache, newMaxSize);
    }

    private long getCacheMaximum(Object underlyingCache) throws ReflectiveOperationException {
        Class<?> clazz = underlyingCache.getClass().getSuperclass();
        Method method = clazz.getDeclaredMethod("maximum", new Class[0]);
        method.setAccessible(true);
        return (Long)method.invoke(underlyingCache, new Object[0]);
    }
}

