/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.cache.hazelcast.hibernate;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.event.events.admin.MaxCacheSizeChangedEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.confluence.impl.cache.hazelcast.hibernate.LocalRegionCacheMaxSizeChangeHelper;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.hazelcast.hibernate.local.LocalRegionCache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRegionCacheMaxSizeAdjuster {
    private static final Logger log = LoggerFactory.getLogger(LocalRegionCacheMaxSizeAdjuster.class);
    private final EventPublisher eventPublisher;
    private final LocalRegionCacheMaxSizeChangeHelper localRegionCacheMaxSizeChangeHelper;
    private final Map<String, LocalRegionCache> caches = new ConcurrentHashMap<String, LocalRegionCache>();

    public LocalRegionCacheMaxSizeAdjuster(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.localRegionCacheMaxSizeChangeHelper = new LocalRegionCacheMaxSizeChangeHelper();
    }

    @VisibleForTesting
    LocalRegionCacheMaxSizeAdjuster(EventPublisher eventPublisher, LocalRegionCacheMaxSizeChangeHelper localRegionCacheMaxSizeChangeHelper) {
        this.eventPublisher = eventPublisher;
        this.localRegionCacheMaxSizeChangeHelper = localRegionCacheMaxSizeChangeHelper;
    }

    public void registerLocalRegionCache(LocalRegionCache localRegionCache) {
        this.caches.put(localRegionCache.getName(), localRegionCache);
    }

    @PostConstruct
    public void postConstruct() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void unregisterForEvents() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onMaxEntriesSettingChangedRemotely(ClusterEventWrapper clusterEventWrapper) {
        clusterEventWrapper.unwrapIfType(MaxCacheSizeChangedEvent.class).ifPresent(this::onMaxEntriesSettingChangedLocally);
    }

    @EventListener
    public void onMaxEntriesSettingChangedLocally(MaxCacheSizeChangedEvent maxCacheSizeChangedEvent) {
        this.changeCacheSize(maxCacheSizeChangedEvent.getCacheName(), maxCacheSizeChangedEvent.getMaxCacheSize());
    }

    private void changeCacheSize(String cacheName, long newMaxSize) {
        LocalRegionCache cache = this.caches.get(cacheName);
        if (cache == null) {
            log.debug("Unable to find cache with name {}. Probably, it is not a local region cache.", (Object)cacheName);
        } else {
            this.localRegionCacheMaxSizeChangeHelper.setNewMaximum(cache, newMaxSize);
            log.info("Max size for cache '{}' was set to {} in runtime.", (Object)cacheName, (Object)newMaxSize);
        }
    }

    public @Nullable Long getCacheSize(String cacheName) {
        LocalRegionCache cache = this.caches.get(cacheName);
        return cache != null ? Long.valueOf(cache.getSizeInMemory()) : null;
    }
}

