/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.cache.hazelcast.hibernate;

import com.atlassian.cache.CacheSettingsDefaultsProvider;
import com.atlassian.confluence.impl.cache.hazelcast.hibernate.LocalRegionCacheMaxSizeAdjuster;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.HazelcastLocalCacheRegionFactory;
import com.hazelcast.hibernate.RegionCache;
import com.hazelcast.hibernate.local.LocalRegionCache;
import com.hazelcast.hibernate.local.TimestampsRegionCache;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.function.Supplier;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.support.RegionNameQualifier;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class ConfluenceHazelcastLocalCacheRegionFactory
extends HazelcastLocalCacheRegionFactory {
    private static final long serialVersionUID = 5547443299912282834L;
    private static final int DEFAULT_CACHE_SIZE = 25000;
    private static final long DEFAULT_CACHE_TTL = 3600000L;
    private final transient CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider;
    private final transient LocalRegionCacheMaxSizeAdjuster localRegionCacheMaxSizeAdjuster;

    public ConfluenceHazelcastLocalCacheRegionFactory(Supplier<HazelcastInstance> hazelcastInstanceSupplier, CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider, LocalRegionCacheMaxSizeAdjuster localRegionCacheMaxSizeAdjuster) {
        this.instance = hazelcastInstanceSupplier.get();
        this.cacheSettingsDefaultsProvider = cacheSettingsDefaultsProvider;
        this.localRegionCacheMaxSizeAdjuster = localRegionCacheMaxSizeAdjuster;
    }

    protected RegionCache createRegionCache(String unqualifiedRegionName, SessionFactoryImplementor sessionFactory, DomainDataRegionConfig regionConfig) {
        this.verifyStarted();
        assert (!RegionNameQualifier.INSTANCE.isQualified(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions()));
        boolean WITH_TOPIC = true;
        String qualifiedRegionName = RegionNameQualifier.INSTANCE.qualify(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions());
        LocalRegionCache regionCache = LocalRegionCache.builder().withRegionFactory((RegionFactory)this).withName(qualifiedRegionName).withHazelcastInstance(this.instance).withRegionConfig(regionConfig).withEvictionConfig((LocalRegionCache.EvictionConfig)new DynamicEvictionConfig(this.cacheSettingsDefaultsProvider, unqualifiedRegionName)).withTopic(true).withFreeHeapBasedCacheEvictor(this.freeHeapBasedCacheEvictor).build();
        this.localRegionCaches.add(regionCache);
        this.localRegionCacheMaxSizeAdjuster.registerLocalRegionCache(regionCache);
        return regionCache;
    }

    protected RegionCache createTimestampsRegionCache(String unqualifiedRegionName, SessionFactoryImplementor sessionFactory) {
        this.verifyStarted();
        assert (!RegionNameQualifier.INSTANCE.isQualified(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions()));
        String qualifiedRegionName = RegionNameQualifier.INSTANCE.qualify(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions());
        TimestampsRegionCache timestampsRegionCache = new TimestampsRegionCache((RegionFactory)this, qualifiedRegionName, this.instance, this.freeHeapBasedCacheEvictor);
        this.localRegionCaches.add(timestampsRegionCache);
        return timestampsRegionCache;
    }

    public static class DynamicEvictionConfig
    implements LocalRegionCache.EvictionConfig {
        private final CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider;
        private final String name;

        public DynamicEvictionConfig(CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider, String name) {
            this.cacheSettingsDefaultsProvider = cacheSettingsDefaultsProvider;
            this.name = name;
        }

        public Duration getTimeToLive() {
            Optional<Long> expireAfterWrite = Optional.ofNullable(this.cacheSettingsDefaultsProvider.getDefaults(this.name).getExpireAfterWrite());
            return Duration.of(expireAfterWrite.orElse(3600000L), ChronoUnit.MILLIS);
        }

        public int getSize() {
            Optional<Integer> maxEntries = Optional.ofNullable(this.cacheSettingsDefaultsProvider.getDefaults(this.name).getMaxEntries());
            return maxEntries.orElse(25000);
        }

        public MaxSizePolicy getMaxSizePolicy() {
            return MaxSizePolicy.PER_NODE;
        }
    }
}

