/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.hazelcast;

import com.atlassian.annotations.Internal;
import com.atlassian.cluster.monitoring.spi.model.NodeIdentifier;
import com.atlassian.cluster.monitoring.spi.model.NodeInformation;
import com.google.common.base.Function;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberSelector;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;
import java.net.InetSocketAddress;
import java.util.Objects;

@Internal
public class HazelcastUtils {
    private static final String CONFIGURED_NODE_NAME = "Confluence.ConfiguredNodeName";

    public static String getMemberId(Member member) {
        return Integer.toHexString(Objects.hash(member.getSocketAddress().getAddress(), member.getSocketAddress().getPort()));
    }

    public static NodeIdentifier getMemberNodeIdentifier(Member member) {
        return new NodeIdentifier(HazelcastUtils.getMemberId(member));
    }

    public static MemberSelector getMemberSelector(NodeIdentifier nodeIdentifier) {
        return member -> HazelcastUtils.getMemberNodeIdentifier(member).equals((Object)nodeIdentifier);
    }

    public static Function<Member, NodeIdentifier> extractNodeId() {
        return HazelcastUtils::getMemberNodeIdentifier;
    }

    public static void setConfiguredMemberName(Member member, String name) {
        member.setStringAttribute(CONFIGURED_NODE_NAME, name);
    }

    public static com.atlassian.fugue.Maybe<String> getConfiguredMemberName(Member member) {
        return com.atlassian.fugue.Option.option((Object)member.getStringAttribute(CONFIGURED_NODE_NAME));
    }

    public static Function<Member, NodeInformation> extractNodeInfo() {
        return member -> {
            InetSocketAddress socketAddress = member.getSocketAddress();
            String hostAddress = String.format("%s:%s", socketAddress.getAddress().getHostAddress(), socketAddress.getPort());
            return new NodeInformation((NodeIdentifier)HazelcastUtils.extractNodeId().apply(member), hostAddress, socketAddress.getAddress().getHostName(), (Maybe)Option.option((Object)member.getStringAttribute(CONFIGURED_NODE_NAME)));
        };
    }
}

