/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.hazelcast;

import com.atlassian.annotations.Internal;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsDefaultsProvider;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.Supplier;
import com.atlassian.cache.hazelcast.HazelcastCacheManager;
import com.atlassian.confluence.cache.CacheSettingsManager;
import com.atlassian.confluence.cache.ConfluenceCache;
import com.atlassian.confluence.cache.ConfluenceMonitoringCache;
import com.atlassian.confluence.cache.DefaultConfluenceCache;
import com.atlassian.confluence.cache.LockingCache;
import com.atlassian.confluence.cache.hazelcast.HazelcastHelper;
import com.atlassian.confluence.cache.hazelcast.LockingCacheManager;
import com.atlassian.confluence.cache.hazelcast.hibernate.HazelcastLockingCache;
import com.atlassian.confluence.cache.hazelcast.monitoring.ConfluenceMonitoringLoader;
import com.atlassian.confluence.cache.hazelcast.monitoring.ConfluenceMonitoringLockingCache;
import com.atlassian.confluence.cluster.hazelcast.HazelcastClusterManager;
import com.atlassian.confluence.util.profiling.ConfluenceMonitoring;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Internal
public class ConfluenceHazelcastCacheManager
implements LockingCacheManager {
    private final HazelcastClusterManager hazelcastClusterManager;
    private final CacheManager localCacheManager;
    private final ConfluenceMonitoring confluenceMonitoring;
    private final CacheSettingsManager cacheSettingsManager;
    private final HazelcastHelper hazelcastHelper;
    private com.atlassian.util.concurrent.Supplier<HazelcastCacheManager> delegate = new LazyReference<HazelcastCacheManager>(){

        protected HazelcastCacheManager create() throws Exception {
            HazelcastCacheManager cacheManager = new HazelcastCacheManager(ConfluenceHazelcastCacheManager.this.hazelcastClusterManager.get(), (CacheFactory)ConfluenceHazelcastCacheManager.this.localCacheManager, (CacheSettingsDefaultsProvider)ConfluenceHazelcastCacheManager.this.cacheSettingsManager);
            cacheManager.init();
            return cacheManager;
        }
    };

    public ConfluenceHazelcastCacheManager(HazelcastClusterManager hazelcastClusterManager, CacheManager localCacheManager, ConfluenceMonitoring confluenceMonitoring, CacheSettingsManager cacheSettingsManager, HazelcastHelper hazelcastHelper) {
        this.hazelcastClusterManager = (HazelcastClusterManager)Preconditions.checkNotNull((Object)hazelcastClusterManager);
        this.localCacheManager = (CacheManager)Preconditions.checkNotNull((Object)localCacheManager);
        this.confluenceMonitoring = (ConfluenceMonitoring)Preconditions.checkNotNull((Object)confluenceMonitoring);
        this.cacheSettingsManager = (CacheSettingsManager)Preconditions.checkNotNull((Object)cacheSettingsManager);
        this.hazelcastHelper = (HazelcastHelper)Preconditions.checkNotNull((Object)hazelcastHelper);
    }

    private HazelcastCacheManager getDelegate() {
        return (HazelcastCacheManager)this.delegate.get();
    }

    private Collection<Cache<?, ?>> wrapCaches(Collection<Cache<?, ?>> caches) {
        return Collections2.transform(caches, cache -> this.wrapCache((Cache)cache));
    }

    private <K, V> Cache<K, V> wrapCache(Cache<K, V> cache) {
        return new ConfluenceMonitoringCache((ConfluenceCache)new DefaultConfluenceCache(cache), this.confluenceMonitoring);
    }

    @Nullable
    private <K, V> CacheLoader<K, V> wrapLoader(String cacheName, @Nullable CacheLoader<K, V> loader) {
        if (loader == null) {
            return null;
        }
        return new ConfluenceMonitoringLoader<K, V>(this.confluenceMonitoring, cacheName, loader);
    }

    @Override
    @Nonnull
    public <K, V> LockingCache<K, V> getLockingCache(@Nonnull String name, @Nullable CacheLoader<K, V> loader, @Nonnull CacheSettings cacheSettings) {
        ConfluenceCache cache = (ConfluenceCache)this.getCache(name, this.wrapLoader(name, loader), cacheSettings);
        HazelcastLockingCache lockingCache = new HazelcastLockingCache(this.hazelcastHelper, cache);
        return new ConfluenceMonitoringLockingCache(lockingCache, this.confluenceMonitoring);
    }

    @Nonnull
    @Deprecated
    public Collection<Cache<?, ?>> getCaches() {
        return this.wrapCaches(this.getDelegate().getCaches());
    }

    @Nonnull
    public Collection<ManagedCache> getManagedCaches() {
        return this.getDelegate().getManagedCaches();
    }

    public void flushCaches() {
        this.getDelegate().flushCaches();
    }

    @Nullable
    public ManagedCache getManagedCache(@Nonnull String name) {
        return this.getDelegate().getManagedCache(name);
    }

    public void shutdown() {
        this.getDelegate().shutdown();
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(@Nonnull String name, @Nonnull Supplier<V> supplier) {
        return this.getDelegate().getCachedReference(name, supplier);
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(@Nonnull String name, @Nonnull Supplier<V> supplier, @Nonnull CacheSettings cacheSettings) {
        return this.getDelegate().getCachedReference(name, supplier, cacheSettings);
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(@Nonnull Class<?> owningClass, @Nonnull String name, @Nonnull Supplier<V> supplier) {
        return this.getDelegate().getCachedReference(owningClass, name, supplier);
    }

    @Nonnull
    public <V> CachedReference<V> getCachedReference(@Nonnull Class<?> owningClass, @Nonnull String name, @Nonnull Supplier<V> supplier, @Nonnull CacheSettings cacheSettings) {
        return this.getDelegate().getCachedReference(owningClass, name, supplier, cacheSettings);
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull String name) {
        return this.wrapCache(this.getDelegate().getCache(name));
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull Class<?> owningClass, @Nonnull String name) {
        return this.wrapCache(this.getDelegate().getCache(owningClass, name));
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull String name, @Nullable CacheLoader<K, V> loader) {
        return this.wrapCache(this.getDelegate().getCache(name, this.wrapLoader(name, loader)));
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull String name, @Nullable CacheLoader<K, V> loader, @Nonnull CacheSettings cacheSettings) {
        return this.wrapCache(this.getDelegate().getCache(name, this.wrapLoader(name, loader), cacheSettings));
    }

    @Nonnull
    public <K, V> Cache<K, V> getCache(@Nonnull String name, @Nonnull Class<K> keyType, @Nonnull Class<V> valueType) {
        return this.wrapCache(this.getDelegate().getCache(name, keyType, valueType));
    }
}

