/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cluster.hazelcast.monitoring;

import com.atlassian.annotations.Internal;
import com.atlassian.cluster.monitoring.spi.ClusterMonitoring;
import com.atlassian.cluster.monitoring.spi.model.MonitoringError;
import com.atlassian.cluster.monitoring.spi.model.NodeIdentifier;
import com.atlassian.cluster.monitoring.spi.model.NodeInformation;
import com.atlassian.cluster.monitoring.spi.model.Table;
import com.atlassian.confluence.cluster.hazelcast.HazelcastUtils;
import com.atlassian.confluence.cluster.hazelcast.monitoring.RemoteModuleCallable;
import com.atlassian.fugue.Either;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class HazelcastClusterMonitoring
implements ClusterMonitoring {
    private static final Logger log = LoggerFactory.getLogger(HazelcastClusterMonitoring.class);
    private static final long TIMEOUT_DURATION = 5L;
    private static final TimeUnit TIMEOUT_UNIT = TimeUnit.SECONDS;
    private static final String MONITORING_EXECUTOR_KEY = "cluster-monitoring-executor";
    private final HazelcastInstance hazelcastInstance;
    private final IExecutorService executor;

    public HazelcastClusterMonitoring(Supplier<HazelcastInstance> instanceSupplier) {
        this.hazelcastInstance = (HazelcastInstance)Preconditions.checkNotNull((Object)((Supplier)Preconditions.checkNotNull(instanceSupplier)).get());
        this.executor = (IExecutorService)Preconditions.checkNotNull((Object)this.hazelcastInstance.getExecutorService(MONITORING_EXECUTOR_KEY));
    }

    public Either<MonitoringError, NodeIdentifier> getCurrentNode() {
        Member member = this.hazelcastInstance.getCluster().getLocalMember();
        return Either.right((Object)HazelcastUtils.extractNodeId().apply((Object)member));
    }

    public Either<MonitoringError, List<NodeInformation>> getNodes() {
        Set members = this.hazelcastInstance.getCluster().getMembers();
        ArrayList nodeInfos = Lists.newArrayList((Iterable)Collections2.transform((Collection)members, HazelcastUtils.extractNodeInfo()));
        Collections.sort(nodeInfos);
        return Either.right((Object)nodeInfos);
    }

    @Nonnull
    public Either<MonitoringError, Table> getData(ModuleCompleteKey key, NodeIdentifier nodeId) {
        try {
            Future future = this.executor.submit((Callable)new RemoteModuleCallable(key), HazelcastUtils.getMemberSelector(nodeId));
            return Either.right(future.get(5L, TIMEOUT_UNIT));
        }
        catch (Exception e) {
            log.warn("Exception happened when receiving response from node {}", (Object)nodeId, (Object)e);
            MonitoringError error = new MonitoringError(e.getMessage());
            return Either.left((Object)error);
        }
    }

    public boolean isAvailable() {
        return true;
    }
}

