/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.hazelcast.hibernate;

import com.atlassian.confluence.cache.LockingCache;
import com.atlassian.hibernate.extras.tangosol.AtlassianHibernateCache;
import com.atlassian.hibernate.extras.tangosol.CacheEntry;
import com.atlassian.hibernate.extras.tangosol.CacheEntryProcessor;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Supplier;
import com.hazelcast.core.Cluster;
import net.sf.hibernate.cache.CacheException;
import org.joda.time.Duration;

public class HazelcastHibernateCache
implements AtlassianHibernateCache {
    private static final Duration LOCK_LEASE_TIMEOUT = Duration.standardSeconds((long)10L);
    private final LockingCache cache;
    private final Cluster cluster;

    public HazelcastHibernateCache(LockingCache cache, Cluster cluster) {
        this.cache = cache;
        this.cluster = cluster;
    }

    public Object get(Object key) throws CacheException {
        return this.cache.get(key);
    }

    public void put(Object key, Object value) throws CacheException {
        this.cache.put(key, value);
    }

    public void remove(Object key) throws CacheException {
        this.cache.remove(key);
    }

    public void clear() throws CacheException {
        this.cache.removeAll();
    }

    public void destroy() throws CacheException {
        this.cache.removeAll();
    }

    public void lock(Object key) throws CacheException {
        this.cache.lock(key, LOCK_LEASE_TIMEOUT);
    }

    public void unlock(Object key) throws CacheException {
        this.cache.unlock(key);
    }

    public long nextTimestamp() {
        return this.cluster.getClusterTime();
    }

    public int getTimeout() {
        return (int)LOCK_LEASE_TIMEOUT.getMillis();
    }

    public boolean containsKey(Object key) throws CacheException {
        return this.cache.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, K, V> T invoke(K key, CacheEntryProcessor<K, V, T> processor) throws CacheException {
        this.lock(key);
        try {
            LazyReference<V> valueRef = this.cachedValueLazyRef(key);
            Object object = processor.process(this.cacheEntry(key, (Supplier<V>)valueRef));
            return (T)object;
        }
        finally {
            this.unlock(key);
        }
    }

    private <K, V> CacheEntry<K, V> cacheEntry(final K key, final Supplier<V> valueRef) {
        return new CacheEntry<K, V>(){

            public void setValue(V value) {
                HazelcastHibernateCache.this.cache.put(key, value);
            }

            public V getValue() {
                return valueRef.get();
            }

            public K getKey() {
                return key;
            }
        };
    }

    private <K, V> LazyReference<V> cachedValueLazyRef(final K key) {
        return new LazyReference<V>(){

            protected V create() throws Exception {
                return HazelcastHibernateCache.this.cache.get(key);
            }
        };
    }
}

