/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.ehcache.config.migration;

import com.atlassian.confluence.cache.ehcache.config.migration.EhCacheConfigs;
import com.atlassian.confluence.cache.ehcache.config.migration.MigrationCacheConfig;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.Resource;

class EhCacheConfigReader {
    EhCacheConfigReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EhCacheConfigs extractCacheConfigs(Resource resource) throws IOException, DocumentException {
        InputStream inputStream = resource.getInputStream();
        try {
            Document doc = new SAXReader().read(inputStream);
            EhCacheConfigs ehCacheConfigs = EhCacheConfigReader.extractCacheConfigs(doc, resource.getDescription());
            return ehCacheConfigs;
        }
        finally {
            inputStream.close();
        }
    }

    private static EhCacheConfigs extractCacheConfigs(Document configDoc, String source) {
        List cacheElements = configDoc.selectNodes("/ehcache/cache");
        Collection namedCaches = Collections2.transform((Collection)cacheElements, EhCacheConfigReader.cacheConfigFunction());
        Element defaultCacheElement = (Element)configDoc.selectSingleNode("/ehcache/defaultCache");
        MigrationCacheConfig defaultCacheConfig = EhCacheConfigReader.extractFrom(defaultCacheElement);
        return new EhCacheConfigs(source, defaultCacheConfig, namedCaches);
    }

    private static Function<Element, MigrationCacheConfig> cacheConfigFunction() {
        return new Function<Element, MigrationCacheConfig>(){

            public MigrationCacheConfig apply(Element configElement) {
                return EhCacheConfigReader.extractFrom(configElement);
            }
        };
    }

    private static MigrationCacheConfig extractFrom(Element cacheConfigElement) {
        MigrationCacheConfig config = new MigrationCacheConfig(cacheConfigElement.attributeValue("name"), (String)Objects.firstNonNull((Object)cacheConfigElement.attributeValue("maxEntriesLocalHeap"), (Object)cacheConfigElement.attributeValue("maxElementsInMemory")), cacheConfigElement.attributeValue("timeToIdleSeconds"), cacheConfigElement.attributeValue("timeToLiveSeconds"), cacheConfigElement.attributeValue("overflowToDisk"), cacheConfigElement.attributeValue("eternal"));
        return config;
    }
}

