/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.ehcache;

import com.atlassian.confluence.cache.ehcache.EhCacheConfigStore;
import com.atlassian.confluence.setup.BootstrapManager;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class EhCacheConfigFileStore
implements InitializingBean,
EhCacheConfigStore {
    private static final Logger log = LoggerFactory.getLogger(EhCacheConfigFileStore.class);
    private static final String CONFIG_FILENAME = "cache-settings-overrides.properties";
    private static final String CONFIG_FILE_HEADER_COMMENT = "EhCache Config Settings";
    private final File configFile;

    public EhCacheConfigFileStore(BootstrapManager bootstrapManager) {
        this.configFile = new File(bootstrapManager.getSharedHome(), "config" + File.separatorChar + CONFIG_FILENAME);
    }

    public void afterPropertiesSet() throws Exception {
        this.ensureConfigurationFileCreated();
    }

    @Override
    public synchronized Properties readStoredConfig() throws IOException {
        Properties config = new Properties();
        config.load(new FileReader(this.configFile));
        return config;
    }

    private synchronized void ensureConfigurationFileCreated() {
        if (!this.configFile.exists()) {
            log.info("Creating default cache config file");
            try {
                EhCacheConfigFileStore.storeConfig(this.configFile, new Properties());
            }
            catch (IOException e) {
                log.error("Failed to store ehcache config properties to " + this.configFile.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void updateStoredConfig(Properties properties) throws IOException {
        EhCacheConfigFileStore.storeConfig(this.configFile, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeConfig(File file, Properties properties) throws IOException {
        log.info("Storing config file to {}", (Object)file.getAbsolutePath());
        EhCacheConfigFileStore.ensureParentDirExists(file);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            properties.store(fileWriter, CONFIG_FILE_HEADER_COMMENT);
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }

    private static void ensureParentDirExists(File file) {
        File parentDir = file.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            parentDir.mkdirs();
        }
    }
}

