/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.ehcache;

import com.atlassian.cache.Cache;
import com.atlassian.confluence.cache.ehcache.ConfluenceEhCache;
import com.atlassian.confluence.cache.ehcache.ValueWrapper;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.config.CacheConfiguration;

class DefaultConfluenceEhCache<K, V>
implements ConfluenceEhCache<K, V> {
    private final Cache<K, ValueWrapper<V>> atlassianCacheDelegate;
    private final CacheConfiguration ehCacheConfig;

    public DefaultConfluenceEhCache(Cache<K, V> atlassianCacheDelegate, CacheConfiguration ehCacheConfig) {
        this.atlassianCacheDelegate = (Cache)Preconditions.checkNotNull(atlassianCacheDelegate);
        this.ehCacheConfig = (CacheConfiguration)Preconditions.checkNotNull((Object)ehCacheConfig);
    }

    public V get(K key) {
        return this.unwrapValue(this.atlassianCacheDelegate.get(key));
    }

    public boolean containsKey(@NotNull K k) {
        return this.atlassianCacheDelegate.containsKey(k);
    }

    public Collection<K> getKeys() {
        return this.atlassianCacheDelegate.getKeys();
    }

    public String getName() {
        return this.atlassianCacheDelegate.getName();
    }

    public void put(K key, V value) {
        this.atlassianCacheDelegate.put(key, this.wrapValue(value));
    }

    public void remove(K key) {
        this.atlassianCacheDelegate.remove(key);
    }

    public void removeAll() {
        this.atlassianCacheDelegate.removeAll();
    }

    @Override
    public boolean updateMaxEntriesLocalHeap(long max) {
        this.ehCacheConfig.setMaxEntriesLocalHeap(max);
        return true;
    }

    public void setTimeToLive(long timeToLive, TimeUnit timeUnit) {
        Preconditions.checkArgument((timeToLive >= 0L ? 1 : 0) != 0, (Object)"time to live must be greater than or equal to 0.");
        Preconditions.checkArgument((timeUnit != null ? 1 : 0) != 0, (Object)"timeunit is required.");
        this.ehCacheConfig.setTimeToLiveSeconds(timeUnit.toSeconds(timeToLive));
    }

    public V putIfAbsent(K key, V value) {
        return this.unwrapValue(this.atlassianCacheDelegate.putIfAbsent(key, this.wrapValue(value)));
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.atlassianCacheDelegate.replace(key, this.wrapValue(oldValue), this.wrapValue(newValue));
    }

    public boolean remove(K key, V value) {
        return this.atlassianCacheDelegate.remove(key, this.wrapValue(value));
    }

    private ValueWrapper<V> wrapValue(V value) {
        return new ValueWrapper<V>(this.getName(), value);
    }

    private V unwrapValue(Object value) {
        if (value instanceof ValueWrapper) {
            ValueWrapper wrappedValue = (ValueWrapper)value;
            return (V)wrappedValue.getValue();
        }
        return (V)value;
    }

    @Override
    public CacheConfiguration getEhCacheConfiguration() {
        return this.ehCacheConfig;
    }
}

