/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.ehcache;

import com.atlassian.confluence.cache.ConfigurableCache;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

public class ConfluenceEhCache<K, V>
implements ConfigurableCache<K, V> {
    private final Ehcache delegate;

    public ConfluenceEhCache(Ehcache delegate) {
        this.delegate = delegate;
    }

    public V get(K key) {
        Element element = this.delegate.get(key);
        if (element != null) {
            return this.unwrapValue(element.getObjectValue());
        }
        return null;
    }

    public Collection<K> getKeys() {
        return this.delegate.getKeys();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public void put(K key, V value) {
        this.delegate.put(this.element(key, value));
    }

    private Element element(K key, V value) {
        return new Element(key, this.wrapValue(value));
    }

    public void remove(K key) {
        this.delegate.remove(key);
    }

    public void removeAll() {
        this.delegate.removeAll();
    }

    void setMaxEntriesLocalHeap(long max) {
        this.delegate.getCacheConfiguration().setMaxEntriesLocalHeap(max);
    }

    public void setTimeToLive(long timeToLive, TimeUnit timeUnit) {
        Preconditions.checkArgument((timeToLive >= 0L ? 1 : 0) != 0, (Object)"time to live must be greater than or equal to 0.");
        Preconditions.checkArgument((timeUnit != null ? 1 : 0) != 0, (Object)"timeunit is required.");
        this.delegate.getCacheConfiguration().setTimeToLiveSeconds(timeUnit.toSeconds(timeToLive));
    }

    public V putIfAbsent(K key, V value) {
        Element previousElement = this.delegate.putIfAbsent(this.element(key, value));
        return previousElement == null ? null : (V)this.unwrapValue(previousElement.getObjectValue());
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.delegate.replace(this.element(key, oldValue), this.element(key, newValue));
    }

    public boolean remove(K key, V value) {
        return this.delegate.removeElement(this.element(key, value));
    }

    private ValueWrapper<V> wrapValue(V value) {
        return new ValueWrapper(this.delegate.getName(), value);
    }

    private V unwrapValue(Object value) {
        if (value instanceof ValueWrapper) {
            ValueWrapper wrappedValue = (ValueWrapper)value;
            return (V)wrappedValue.getValue();
        }
        return (V)value;
    }

    private static class ValueWrapper<T> {
        private final String cacheName;
        private final T value;

        private ValueWrapper(String cacheName, T value) {
            this.cacheName = cacheName;
            this.value = value;
        }

        private T getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValueWrapper that = (ValueWrapper)o;
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        public String toString() {
            return "ValueWrapper{cacheName='" + this.cacheName + '\'' + ", value=" + this.value + '}';
        }
    }
}

