/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.ehcache.config.migration;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

class MigrationCacheConfig {
    final String name;
    final String maxElementsInMemory;
    final String timeToIdleSeconds;
    final String timeToLiveSeconds;
    final String overflowToDisk;
    final String eternal;

    MigrationCacheConfig(String name, String maxElementsInMemory, String timeToIdleSeconds, String timeToLiveSeconds, String overflowToDisk, String eternal) {
        this.name = name;
        this.maxElementsInMemory = maxElementsInMemory;
        this.timeToIdleSeconds = timeToIdleSeconds;
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.overflowToDisk = overflowToDisk;
        this.eternal = eternal;
    }

    boolean isDefaultCache() {
        return this.name == null;
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    boolean equalsExcludingMigratableProperties(MigrationCacheConfig other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[]{"name", "maxElementsInMemory"});
    }

    boolean equalsExactly(MigrationCacheConfig other) {
        return this.equals(other);
    }

    boolean equalsExcludingName(MigrationCacheConfig other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[]{"name"});
    }

    boolean matchesConfigOf(MigrationCacheConfig other) {
        return this.equalsExcludingName(other);
    }

    boolean matchesMigratablePropertiesOf(MigrationCacheConfig other) {
        return this.maxElementsInMemory.equals(other.maxElementsInMemory);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return "{eternal='" + this.eternal + '\'' + ", overflowToDisk='" + this.overflowToDisk + '\'' + ", maxElementsInMemory='" + this.maxElementsInMemory + '\'' + ", timeToIdleSeconds='" + this.timeToIdleSeconds + '\'' + ", timeToLiveSeconds='" + this.timeToLiveSeconds + '\'' + ", name='" + StringUtils.defaultString((String)this.name, (String)"<default>") + '\'' + '}';
    }
}

