/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.ehcache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.cache.ehcache.ConfluenceEhCache;
import com.atlassian.confluence.cache.ehcache.EhCacheConfig;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCacheManager
implements CacheManager {
    private static final Logger startupLog = LoggerFactory.getLogger((String)"com.atlassian.confluence.lifecycle");
    private net.sf.ehcache.CacheManager delegate;
    private final List<String> nonFlushableCaches;
    private final ConcurrentMap<String, ReentrantLock> cacheCreateLocks = new ConcurrentHashMap<String, ReentrantLock>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EhCacheManager(List<String> nonFlushableCaches, EhCacheConfig ehCacheConfig) {
        startupLog.info("Loading EhCache cache manager");
        this.nonFlushableCaches = nonFlushableCaches;
        InputStream inputStream = null;
        try {
            inputStream = ehCacheConfig.getInputStream();
            this.delegate = net.sf.ehcache.CacheManager.create((InputStream)inputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public void flushCaches() {
        for (String cacheName : this.delegate.getCacheNames()) {
            if (this.nonFlushableCaches.contains(cacheName)) continue;
            this.delegate.getCache(cacheName).removeAll();
        }
    }

    public Collection<Cache> getCaches() {
        ArrayList<Cache> ret = new ArrayList<Cache>();
        for (String cacheName : this.delegate.getCacheNames()) {
            ret.add(this.getCache(cacheName));
        }
        return ret;
    }

    public Cache getCache(String name) {
        return new ConfluenceEhCache(this.getDelegateCache(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private net.sf.ehcache.Cache getDelegateCache(String name) {
        net.sf.ehcache.Cache cache = this.delegate.getCache(name);
        if (cache == null) {
            ReentrantLock lock = new ReentrantLock();
            ReentrantLock previousLock = this.cacheCreateLocks.putIfAbsent(name, lock);
            if (previousLock != null) {
                lock = previousLock;
            }
            try {
                lock.lock();
                cache = this.createCacheRegion(name);
            }
            finally {
                lock.unlock();
                this.cacheCreateLocks.remove(name);
            }
        }
        return cache;
    }

    private net.sf.ehcache.Cache createCacheRegion(String name) {
        if (!this.delegate.cacheExists(name)) {
            this.delegate.addCache(name);
        }
        return this.delegate.getCache(name);
    }
}

