/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.heading.anchor;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IdGenerator {
    private final Pattern allowedCharacters = Pattern.compile("[\\w\\-_]+", 256);
    private final Map<String, Integer> identityMap;
    private final String prefix;
    private final String suffix;
    private String defaultIdentifier;

    private IdGenerator(Builder builder) {
        this.defaultIdentifier = builder.defaultIdentifier;
        this.prefix = builder.prefix;
        this.suffix = builder.suffix;
        this.identityMap = new HashMap<String, Integer>();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String generateId(String text) {
        String normalizedIdentity;
        String string = normalizedIdentity = text != null ? this.normalizeText(text) : this.defaultIdentifier;
        if (normalizedIdentity.length() == 0) {
            normalizedIdentity = this.defaultIdentifier;
        }
        if (!this.identityMap.containsKey(normalizedIdentity)) {
            this.identityMap.put(normalizedIdentity, 1);
            return this.prefix + normalizedIdentity + this.suffix;
        }
        int currentCount = this.identityMap.get(normalizedIdentity);
        this.identityMap.put(normalizedIdentity, currentCount + 1);
        return this.prefix + normalizedIdentity + "-" + currentCount + this.suffix;
    }

    private String normalizeText(String text) {
        String firstPassNormalising = text.toLowerCase().replace(" ", "-");
        StringBuilder sb = new StringBuilder();
        Matcher matcher = this.allowedCharacters.matcher(firstPassNormalising);
        while (matcher.find()) {
            sb.append(matcher.group());
        }
        return sb.toString();
    }

    public static class Builder {
        private String defaultIdentifier = "id";
        private String prefix = "";
        private String suffix = "";

        public IdGenerator build() {
            return new IdGenerator(this);
        }

        public Builder defaultId(String defaultId) {
            this.defaultIdentifier = defaultId;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }
    }
}

