/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.heading.anchor;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IdGenerator {
    private final Pattern allowedCharacters = Pattern.compile("[\\w\\-_]+", 256);
    private final Map<String, Integer> identityMap;
    private String defaultIdentifier;

    private IdGenerator(Builder builder) {
        this.defaultIdentifier = builder.defaultIdentifier;
        this.identityMap = new HashMap<String, Integer>();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String generateId(String text) {
        String normalizedIdentity;
        String string = normalizedIdentity = text != null ? this.normalizeText(text) : this.defaultIdentifier;
        if (normalizedIdentity.length() == 0) {
            normalizedIdentity = this.defaultIdentifier;
        }
        if (!this.identityMap.containsKey(normalizedIdentity)) {
            this.identityMap.put(normalizedIdentity, 1);
            return normalizedIdentity;
        }
        int currentCount = this.identityMap.get(normalizedIdentity);
        this.identityMap.put(normalizedIdentity, currentCount + 1);
        return normalizedIdentity + "-" + currentCount;
    }

    private String normalizeText(String text) {
        String firstPassNormalising = text.toLowerCase().replace(" ", "-");
        StringBuilder sb = new StringBuilder();
        Matcher matcher = this.allowedCharacters.matcher(firstPassNormalising);
        while (matcher.find()) {
            sb.append(matcher.group());
        }
        return sb.toString();
    }

    public static class Builder {
        private String defaultIdentifier = "id";

        public IdGenerator build() {
            return new IdGenerator(this);
        }

        public Builder defaultId(String defaultId) {
            return this;
        }
    }
}

