/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.autolink;

import java.util.EnumSet;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.node.Text;
import org.commonmark.node.Visitor;
import org.commonmark.parser.PostProcessor;
import org.nibor.autolink.LinkExtractor;
import org.nibor.autolink.LinkSpan;
import org.nibor.autolink.LinkType;

public class AutolinkPostProcessor
implements PostProcessor {
    private LinkExtractor linkExtractor = LinkExtractor.builder().linkTypes(EnumSet.of(LinkType.URL, LinkType.EMAIL)).build();

    public Node process(Node node) {
        AutolinkVisitor autolinkVisitor = new AutolinkVisitor();
        node.accept((Visitor)autolinkVisitor);
        return node;
    }

    private void linkify(Text text) {
        String literal = text.getLiteral();
        Iterable links = this.linkExtractor.extractLinks((CharSequence)literal);
        Text lastNode = text;
        int last = 0;
        for (LinkSpan link : links) {
            String linkText = literal.substring(link.getBeginIndex(), link.getEndIndex());
            if (link.getBeginIndex() != last) {
                lastNode = AutolinkPostProcessor.insertNode((Node)new Text(literal.substring(last, link.getBeginIndex())), (Node)lastNode);
            }
            Text contentNode = new Text(linkText);
            String destination = AutolinkPostProcessor.getDestination(link, linkText);
            Link linkNode = new Link(destination, null);
            linkNode.appendChild((Node)contentNode);
            lastNode = AutolinkPostProcessor.insertNode((Node)linkNode, (Node)lastNode);
            last = link.getEndIndex();
        }
        if (last != literal.length()) {
            AutolinkPostProcessor.insertNode((Node)new Text(literal.substring(last)), (Node)lastNode);
        }
        text.unlink();
    }

    private static String getDestination(LinkSpan linkSpan, String linkText) {
        if (linkSpan.getType() == LinkType.EMAIL) {
            return "mailto:" + linkText;
        }
        return linkText;
    }

    private static Node insertNode(Node node, Node insertAfterNode) {
        insertAfterNode.insertAfter(node);
        return node;
    }

    private class AutolinkVisitor
    extends AbstractVisitor {
        int inLink = 0;

        private AutolinkVisitor() {
        }

        public void visit(Link link) {
            ++this.inLink;
            super.visit(link);
            --this.inLink;
        }

        public void visit(Text text) {
            if (this.inLink == 0) {
                AutolinkPostProcessor.this.linkify(text);
            }
        }
    }
}

