/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cmpt.crypto;

import org.apache.commons.lang3.StringUtils;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BcryptAnalyticsEmailHasher {
    private static final Logger log = LoggerFactory.getLogger(BcryptAnalyticsEmailHasher.class);
    private final String providedSalt;
    private final String transformedSalt;

    public BcryptAnalyticsEmailHasher() {
        this.providedSalt = "$2b$11$wgr1TJNVKwiK/dQBd3HKm.";
        String salt = this.providedSalt.substring(this.providedSalt.lastIndexOf("$") + 1);
        String fixedAlgorithm = this.providedSalt.substring(0, this.providedSalt.lastIndexOf("$")).replace("b", "a");
        this.transformedSalt = fixedAlgorithm + "$" + salt;
    }

    public String hash(String email) {
        if (email == null) {
            return null;
        }
        try {
            return this.providedSalt + BCrypt.hashpw((String)this.cleanEmail(email), (String)this.transformedSalt).substring(this.transformedSalt.length());
        }
        catch (IllegalArgumentException e) {
            log.warn("Malformed email address", (Throwable)e);
            return null;
        }
    }

    private String cleanEmail(String email) {
        String[] emailParts = email.toLowerCase().split("@");
        if (emailParts.length != 2) {
            throw new IllegalArgumentException("Malformed email address. Does not contain only one mandatory symbol @");
        }
        return StringUtils.remove((String)StringUtils.substringBefore((String)emailParts[0], (String)"+"), (String)".") + "@" + emailParts[1];
    }
}

