/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cmpt.check.mapper;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.email.EmailData;
import com.atlassian.cmpt.check.email.EmailFormatChecker;
import com.atlassian.cmpt.check.mapper.AbstractMapper;
import com.atlassian.cmpt.check.mapper.EmailFormatDataProvider;
import com.atlassian.cmpt.check.mapper.EmailInvalid;
import java.util.List;
import java.util.stream.Collectors;

public class EmailFormatMapper
extends AbstractMapper {
    private final EmailFormatDataProvider dataProvider;

    public EmailFormatMapper(EmailFormatDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Override
    public void inject(CheckResultDto dto, CheckResult checkResult) {
        List<EmailData> violations;
        String description;
        switch (dto.getStatus()) {
            case SUCCESS: {
                description = "All users have valid email addresses";
                break;
            }
            case ERROR: 
            case WARNING: {
                description = "Invalid email addresses";
                break;
            }
            case RUNNING: {
                description = "Checking format of email addresses";
                break;
            }
            case EXECUTION_ERROR: {
                description = "We couldn\u2019t check for invalid email addresses";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported status.");
            }
        }
        dto.setDescription(description);
        if (checkResult != null && !(violations = EmailFormatChecker.retrieveInvalidEmails(checkResult.details)).isEmpty()) {
            List invalids = violations.stream().map((? super T violation) -> new EmailInvalid(violation.id, violation.email, this.dataProvider.getUrlByUser(violation.id))).collect(Collectors.toList());
            CheckDetailsDto details = new CheckDetailsDto();
            details.setListOfOccurrences(invalids);
            dto.setDetails(details);
            dto.setNumberOfOccurrences(invalids.size());
        }
    }
}

