/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cmpt.check.mapper;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.cmpt.check.mapper.CheckResultMapper;

public abstract class AbstractMapper
implements CheckResultMapper {
    protected abstract void inject(CheckResultDto var1, CheckResult var2);

    @Override
    public CheckResultDto map(CheckStatus checkStatus) {
        CheckResultDto dto = new CheckResultDto();
        dto.setCheckType(checkStatus.checkType);
        dto.setLastExecution(checkStatus.lastExecutionTime);
        dto.setExecutionErrorCode(Checker.retrieveExecutionErrorCode(checkStatus.checkResult));
        dto.setStatus(this.getResultStatus(checkStatus));
        this.inject(dto, checkStatus.checkResult);
        return dto;
    }

    private Status getResultStatus(CheckStatus checkStatus) {
        if (checkStatus.checkResult == null) {
            return Status.RUNNING;
        }
        if (Checker.retrieveExecutionErrorCode(checkStatus.checkResult) != null) {
            return Status.EXECUTION_ERROR;
        }
        return checkStatus.checkResult.success ? Status.SUCCESS : Status.ERROR;
    }
}

