/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cmpt.check.email;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.Checker;
import com.atlassian.cmpt.check.email.EmailCheckContext;
import com.atlassian.cmpt.check.email.EmailDuplicate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EmailDuplicateChecker
implements Checker<EmailCheckContext> {
    private static final String VIOLATIONS = "violations";

    @Override
    public CheckResult check(EmailCheckContext ctx) {
        Map groupByEmailMap = ctx.emails.stream().filter(emailData -> emailData.email != null).collect(Collectors.groupingBy(emailData -> emailData.email.trim(), Collectors.mapping(emailData -> emailData.id, Collectors.toList())));
        List<EmailDuplicate> duplicates = groupByEmailMap.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> new EmailDuplicate((String)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
        return this.buildCheckResult(duplicates);
    }

    private CheckResult buildCheckResult(List<EmailDuplicate> duplicates) {
        return new CheckResult(duplicates.isEmpty(), Collections.singletonMap(VIOLATIONS, duplicates));
    }

    public static List<EmailDuplicate> retrieveEmailDuplicates(Map<String, Object> details) {
        return details.getOrDefault(VIOLATIONS, Collections.emptyList());
    }
}

