/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.servlet;

import com.atlassian.cache.servlet.handler.CacheExpirationHandler;
import com.atlassian.cache.servlet.handler.LastModifiedCacheExpirationHandler;
import com.atlassian.cache.servlet.resolver.ContentResolver;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.apache.log4j.Logger;

public class CombinedCachingServlet
extends HttpServlet {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private static final String DEFAULT_CONTENT_TYPE = "text/javascript";
    private static final String CONTENT_RESOLVER_PREFIX = "content.resolver";
    public static final String DEFAULT_ENCODING = "UTF-8";
    private String data = null;
    private CacheExpirationHandler cacheExpirationHandler;
    private String contentType;
    private HashMap contentResolvers;
    private MultiMap contentByResolver;

    public synchronized void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.initializeCacheExpirationHandler(servletConfig.getInitParameter("cache.expiration.handler.class"));
        this.initializeContentType(servletConfig.getInitParameter("content.type"));
        this.initializeContentResolvers(servletConfig);
        this.initializeContentParams();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType(this.contentType);
        if (this.getCacheExpirationHandler().checkRequest(request, response)) {
            return;
        }
        response.getWriter().write(this.getDataToSend(request, response));
        response.getWriter().flush();
    }

    private String getDataToSend(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.isCacheDisabled()) {
            return this.makeData(request, response);
        }
        return this.getCachedData(request, response);
    }

    private synchronized String getCachedData(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.data == null) {
            this.data = this.makeData(request, response);
        }
        return this.data;
    }

    private boolean isCacheDisabled() {
        return "true".equals(System.getProperty("atlassian.disable.caches", "false"));
    }

    private String makeData(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            StringBuffer buffer = new StringBuffer();
            Iterator iterator = this.contentResolvers.keySet().iterator();
            while (iterator.hasNext()) {
                String resolverKey = (String)iterator.next();
                if (!this.contentByResolver.containsKey((Object)resolverKey)) continue;
                Iterator iterator1 = ((Collection)this.contentByResolver.get((Object)resolverKey)).iterator();
                while (iterator1.hasNext()) {
                    String path = (String)iterator1.next();
                    ContentResolver resolver = (ContentResolver)this.contentResolvers.get(resolverKey);
                    buffer.append(resolver.getContent(path, request, response));
                }
            }
            return buffer.toString();
        }
        catch (IOException e) {
            this.log.error((Object)("Error building combined cached servlet data: " + request.getRequestURI() + " - " + e.toString()), (Throwable)e);
            throw e;
        }
        catch (ServletException e) {
            this.log.error((Object)("Error building combined cached servlet data: " + request.getRequestURI() + " - " + e.toString()), (Throwable)e);
            throw e;
        }
    }

    private CacheExpirationHandler getCacheExpirationHandler() {
        return this.cacheExpirationHandler;
    }

    private void initializeContentParams() {
        this.contentByResolver = new MultiHashMap();
        Enumeration e = this.getInitParameterNames();
        TreeSet sortedNames = new TreeSet();
        while (e.hasMoreElements()) {
            sortedNames.add(e.nextElement());
        }
        Iterator iterator = this.contentResolvers.keySet().iterator();
        while (iterator.hasNext()) {
            String resolverKey = (String)iterator.next();
            Iterator i = sortedNames.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                if (!name.startsWith(resolverKey)) continue;
                this.contentByResolver.put((Object)resolverKey, (Object)this.getInitParameter(name));
            }
        }
    }

    private void initializeContentResolvers(ServletConfig config) throws ServletException {
        this.contentResolvers = new HashMap();
        Enumeration e = this.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(CONTENT_RESOLVER_PREFIX)) continue;
            Object objResolver = this.getObjectForClass(this.getInitParameter(name));
            if (objResolver != null && objResolver instanceof ContentResolver) {
                ContentResolver resolver = (ContentResolver)objResolver;
                resolver.init(config);
                String key = name.substring(CONTENT_RESOLVER_PREFIX.length() + 1);
                this.contentResolvers.put(key, resolver);
                continue;
            }
            this.log.warn((Object)("The class " + this.getInitParameter(name) + " does not implement ContentResolver."));
        }
    }

    private void initializeContentType(String initParameter) {
        this.contentType = initParameter == null ? DEFAULT_CONTENT_TYPE : initParameter;
    }

    private void initializeCacheExpirationHandler(String cacheExpirationHandlerClass) {
        Object objCacheExpirationHandler = this.getObjectForClass(cacheExpirationHandlerClass);
        if (objCacheExpirationHandler != null && objCacheExpirationHandler instanceof CacheExpirationHandler) {
            this.cacheExpirationHandler = (CacheExpirationHandler)objCacheExpirationHandler;
        } else {
            this.log.info((Object)("Unable to resolve class: " + cacheExpirationHandlerClass + " as an implementation of CacheExpirationHandler"));
            this.cacheExpirationHandler = new LastModifiedCacheExpirationHandler();
            this.log.info((Object)"Using the LastModifiedCacheExpirationHandler cache expiration handler");
        }
    }

    private Object getObjectForClass(String clazz) {
        Object obj = null;
        try {
            if (clazz != null) {
                obj = Class.forName(clazz).newInstance();
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Unable to resolve class for className: " + clazz));
        }
        return obj;
    }
}

