package com.atlassian.cache.servlet.resolver;

import com.atlassian.cache.servlet.CombinedCachingServlet;
import org.apache.commons.io.IOUtils;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * Implements a simple resolver that tries to find the resource off of the classpath.
 */
public class ResourceStreamResolver implements ContentResolver
{
    public String getContent(String path, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
    {
        return writeFile(request.getSession().getServletContext(), path);
    }

    public void init(ServletConfig servletConfig) throws ServletException
    {
        // Do nothing here
    }

    private String writeFile(ServletContext context, String path) throws IOException, ServletException
    {
        final ByteArrayOutputStream os = new ByteArrayOutputStream();
        final InputStream is = context.getResourceAsStream(path);
        if (is != null)
        {
            IOUtils.copy(is, os);
        }
        else
        {
            throw new ServletException("resource " + path + " not found.");
        }
        return os.toString(CombinedCachingServlet.DEFAULT_ENCODING);
    }
}
