package com.atlassian.cache.servlet.resolver;

import com.atlassian.cache.servlet.CombinedCachingServlet;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;

/**
 * This content resolver can get content from the DWRServlet.
 */
public class DwrContentResolver implements ContentResolver
{
    private BogusDwrServlet dwrServlet = new BogusDwrServlet();


    public String getContent(String path, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
    {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        dwrServlet.doGet(new EvilHttpRequest(request, path), new OutputCollectingResponse(response, os));
        return os.toString(CombinedCachingServlet.DEFAULT_ENCODING);
    }

    public void init(ServletConfig servletConfig) throws ServletException
    {
        dwrServlet = new BogusDwrServlet();
        dwrServlet.init(servletConfig);
    }

    public static class EvilHttpRequest implements HttpServletRequest
    {
        private HttpServletRequest wrappedRequest;
        private String pathInfo;

        public EvilHttpRequest(HttpServletRequest wrappedRequest, String pathInfo)
        {
            this.wrappedRequest = wrappedRequest;
            this.pathInfo = pathInfo;
        }


        public String getAuthType()
        {
            return wrappedRequest.getAuthType();
        }

        public Cookie[] getCookies()
        {
            return wrappedRequest.getCookies();
        }

        public long getDateHeader(String s)
        {
            return wrappedRequest.getDateHeader(s);
        }

        public String getHeader(String s)
        {
            return wrappedRequest.getHeader(s);
        }

        public Enumeration getHeaders(String s)
        {
            return wrappedRequest.getHeaders(s);
        }

        public Enumeration getHeaderNames()
        {
            return wrappedRequest.getHeaderNames();
        }

        public int getIntHeader(String s)
        {
            return wrappedRequest.getIntHeader(s);
        }

        public String getMethod()
        {
            return wrappedRequest.getMethod();
        }

        public String getPathInfo()
        {
            return pathInfo;
        }

        public String getPathTranslated()
        {
            return wrappedRequest.getPathTranslated();
        }

        public String getContextPath()
        {
            return wrappedRequest.getContextPath();
        }

        public String getQueryString()
        {
            return wrappedRequest.getQueryString();
        }

        public String getRemoteUser()
        {
            return wrappedRequest.getRemoteUser();
        }

        public boolean isUserInRole(String s)
        {
            return wrappedRequest.isUserInRole(s);
        }

        public Principal getUserPrincipal()
        {
            return wrappedRequest.getUserPrincipal();
        }

        public String getRequestedSessionId()
        {
            return wrappedRequest.getRequestedSessionId();
        }

        public String getRequestURI()
        {
            return wrappedRequest.getRequestURI();
        }

        public StringBuffer getRequestURL()
        {
            return wrappedRequest.getRequestURL();
        }

        public String getServletPath()
        {
            return "/dwr";
        }

        public HttpSession getSession(boolean b)
        {
            return wrappedRequest.getSession(b);
        }

        public HttpSession getSession()
        {
            return wrappedRequest.getSession();
        }

        public boolean isRequestedSessionIdValid()
        {
            return wrappedRequest.isRequestedSessionIdValid();
        }

        public boolean isRequestedSessionIdFromCookie()
        {
            return wrappedRequest.isRequestedSessionIdFromCookie();
        }

        public boolean isRequestedSessionIdFromURL()
        {
            return wrappedRequest.isRequestedSessionIdFromURL();
        }

        /**
         * @deprecated
         */
        public boolean isRequestedSessionIdFromUrl()
        {
            return wrappedRequest.isRequestedSessionIdFromUrl();
        }

        public Object getAttribute(String s)
        {
            return wrappedRequest.getAttribute(s);
        }

        public Enumeration getAttributeNames()
        {
            return wrappedRequest.getAttributeNames();
        }

        public String getCharacterEncoding()
        {
            return wrappedRequest.getCharacterEncoding();
        }

        public void setCharacterEncoding(String s)
                throws UnsupportedEncodingException
        {
            wrappedRequest.setCharacterEncoding(s);
        }

        public int getContentLength()
        {
            return wrappedRequest.getContentLength();
        }

        public String getContentType()
        {
            return wrappedRequest.getContentType();
        }

        public ServletInputStream getInputStream()
                throws IOException
        {
            return wrappedRequest.getInputStream();
        }

        public String getParameter(String s)
        {
            return wrappedRequest.getParameter(s);
        }

        public Enumeration getParameterNames()
        {
            return wrappedRequest.getParameterNames();
        }

        public String[] getParameterValues(String s)
        {
            return wrappedRequest.getParameterValues(s);
        }

        public Map getParameterMap()
        {
            return wrappedRequest.getParameterMap();
        }

        public String getProtocol()
        {
            return wrappedRequest.getProtocol();
        }

        public String getScheme()
        {
            return wrappedRequest.getScheme();
        }

        public String getServerName()
        {
            return wrappedRequest.getServerName();
        }

        public int getServerPort()
        {
            return wrappedRequest.getServerPort();
        }

        public BufferedReader getReader()
                throws IOException
        {
            return wrappedRequest.getReader();
        }

        public String getRemoteAddr()
        {
            return wrappedRequest.getRemoteAddr();
        }

        public String getRemoteHost()
        {
            return wrappedRequest.getRemoteHost();
        }

        public void setAttribute(String s, Object o)
        {
            wrappedRequest.setAttribute(s, o);
        }

        public void removeAttribute(String s)
        {
            wrappedRequest.removeAttribute(s);
        }

        public Locale getLocale()
        {
            return wrappedRequest.getLocale();
        }

        public Enumeration getLocales()
        {
            return wrappedRequest.getLocales();
        }

        public boolean isSecure()
        {
            return wrappedRequest.isSecure();
        }

        public RequestDispatcher getRequestDispatcher(String s)
        {
            return wrappedRequest.getRequestDispatcher(s);
        }

        /**
         * @deprecated
         */
        public String getRealPath(String s)
        {
            return wrappedRequest.getRealPath(s);
        }
    }

    private static class OutputCollectingResponse implements HttpServletResponse
    {
        private HttpServletResponse response;
        private ServletOutputStream os;

        public OutputCollectingResponse(HttpServletResponse response, OutputStream os)
        {
            this.response = response;
            this.os = new ServletOutputStreamAdapter(os);
        }

        public void addCookie(Cookie cookie)
        {
            response.addCookie(cookie);
        }

        public boolean containsHeader(String s)
        {
            return response.containsHeader(s);
        }

        public String encodeURL(String s)
        {
            return response.encodeURL(s);
        }

        public String encodeRedirectURL(String s)
        {
            return response.encodeRedirectURL(s);
        }

        /**
         * @deprecated
         */
        public String encodeUrl(String s)
        {
            return response.encodeUrl(s);
        }

        /**
         * @deprecated
         */
        public String encodeRedirectUrl(String s)
        {
            return response.encodeRedirectUrl(s);
        }

        public void sendError(int i, String s)
                throws IOException
        {
            response.sendError(i, s);
        }

        public void sendError(int i)
                throws IOException
        {
            response.sendError(i);
        }

        public void sendRedirect(String s)
                throws IOException
        {
            response.sendRedirect(s);
        }

        public void setDateHeader(String s, long l)
        {
            //response.setDateHeader(s, l);
        }

        public void addDateHeader(String s, long l)
        {
            //response.addDateHeader(s, l);
        }

        public void setHeader(String s, String s1)
        {
            //response.setHeader(s, s1);
        }

        public void addHeader(String s, String s1)
        {
            //response.addHeader(s, s1);
        }

        public void setIntHeader(String s, int i)
        {
            //response.setIntHeader(s, i);
        }

        public void addIntHeader(String s, int i)
        {
            //response.addIntHeader(s, i);
        }

        public void setStatus(int i)
        {
            response.setStatus(i);
        }

        /**
         * @deprecated
         */
        public void setStatus(int i, String s)
        {
            response.setStatus(i, s);
        }

        public String getCharacterEncoding()
        {
            return response.getCharacterEncoding();
        }

        public ServletOutputStream getOutputStream()
                throws IOException
        {
            return os;
        }

        public PrintWriter getWriter()
                throws IOException
        {
            return new PrintWriter(getOutputStream());
        }

        public void setContentLength(int i)
        {
            response.setContentLength(i);
        }

        public void setContentType(String s)
        {
            response.setContentType(s);
        }

        public void setBufferSize(int i)
        {
            response.setBufferSize(i);
        }

        public int getBufferSize()
        {
            return response.getBufferSize();
        }

        public void flushBuffer()
                throws IOException
        {
            response.flushBuffer();
        }

        public void resetBuffer()
        {
            response.resetBuffer();
        }

        public boolean isCommitted()
        {
            return response.isCommitted();
        }

        public void reset()
        {
            response.reset();
        }

        public void setLocale(Locale locale)
        {
            response.setLocale(locale);
        }

        public Locale getLocale()
        {
            return response.getLocale();
        }
    }

    private static class ServletOutputStreamAdapter extends ServletOutputStream
    {
        private OutputStream os;

        public ServletOutputStreamAdapter(OutputStream os)
        {
            this.os = os;
        }

        public void write(int b) throws IOException
        {
            os.write(b);
        }

        public void flush() throws IOException
        {
            os.flush();
        }

        public void close() throws IOException
        {
            // do nothing
        }
    }

}
