package com.atlassian.cache.servlet.resolver;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Defines a interface which allows a class to resolve content that should be included in the CombinedCachingServlet.
 */
public interface ContentResolver
{
    /**
     * This method will utilize whatever strategey the implementor requires to attain the requested content.
     * @param path is the path to the requested content
     * @param request an HttpServletRequest
     * @param response an HttpServletResonse
     * @return a string representing the content requested
     */
    public String getContent(String path, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException;

    public void init(ServletConfig servletConfig) throws ServletException;
}
