/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.memory;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheEntryListener;
import com.atlassian.cache.CacheException;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheStatisticsKey;
import com.atlassian.cache.Supplier;
import com.atlassian.cache.impl.CacheEntryListenerSupport;
import com.atlassian.cache.impl.DefaultCacheEntryListenerSupport;
import com.atlassian.cache.memory.DelegatingCacheStatistics;
import com.atlassian.cache.memory.ManagedCacheSupport;
import com.atlassian.instrumentation.DefaultInstrumentRegistry;
import com.atlassian.instrumentation.SimpleTimer;
import com.atlassian.instrumentation.caches.CacheCollector;
import com.atlassian.instrumentation.caches.CacheKeys;
import com.google.common.base.Throwables;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collection;
import java.util.Objects;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DelegatingCache<K, V>
extends ManagedCacheSupport
implements Cache<K, V> {
    static final CreateFunction DEFAULT_CREATE_FUNCTION = new DefaultCreateFunction();
    private final Logger eventLogger;
    private final Logger stacktraceLogger;
    private final com.google.common.cache.Cache<K, V> internalCache;
    private final CacheEntryListenerSupport<K, V> listenerSupport;
    private final CacheCollector collector;
    private final CacheLoader<K, V> theLoader;
    private final ConcurrentMap<K, ReentrantLock> barriers = new ConcurrentHashMap<K, ReentrantLock>(16);
    private final Lock loadLock;
    private final Lock removeAllLock;

    protected DelegatingCache(com.google.common.cache.Cache<K, V> internalCache, String name, CacheSettings settings, @Nullable CacheLoader<K, V> theLoader) {
        super(name, settings);
        ReentrantReadWriteLock loadVsRemoveAllLock = new ReentrantReadWriteLock(true);
        this.loadLock = loadVsRemoveAllLock.readLock();
        this.removeAllLock = loadVsRemoveAllLock.writeLock();
        this.internalCache = internalCache;
        this.listenerSupport = new DefaultCacheEntryListenerSupport();
        this.theLoader = theLoader;
        this.collector = new DefaultInstrumentRegistry().pullCacheCollector(name, () -> internalCache.size());
        this.eventLogger = LoggerFactory.getLogger((String)("com.atlassian.cache.event." + name));
        this.stacktraceLogger = LoggerFactory.getLogger((String)("com.atlassian.cache.stacktrace." + name));
    }

    static <K, V> DelegatingCache<K, V> create(com.google.common.cache.Cache<K, V> internalCache, String name, CacheSettings settings, CacheLoader<K, V> cacheLoader) {
        return DEFAULT_CREATE_FUNCTION.create(internalCache, name, settings, cacheLoader);
    }

    public CacheCollector getCacheCollector() {
        return this.collector;
    }

    public boolean containsKey(@Nonnull K key) {
        return null != this.internalCache.getIfPresent(key);
    }

    @Nonnull
    public Collection<K> getKeys() {
        try {
            return this.internalCache.asMap().keySet();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void put(@Nonnull K key, @Nonnull V value) {
        try {
            V oldValue = this.internalCache.asMap().put(key, value);
            if (this.isCollectorStatisticsEnabled()) {
                this.collector.put();
            }
            if (oldValue == null) {
                this.listenerSupport.notifyAdd(key, value);
            }
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public V get(@Nonnull K key) {
        this.rejectNullKey(key);
        if (this.theLoader == null) {
            Object value = this.internalCache.getIfPresent(key);
            if (this.isCollectorStatisticsEnabled()) {
                if (value == null) {
                    this.collector.miss();
                } else {
                    this.collector.hit();
                }
            }
            return (V)value;
        }
        return this.get(key, () -> this.theLoader.load(key));
    }

    @Nonnull
    public V get(@Nonnull K key, @Nonnull Supplier<? extends V> valueLoader) {
        this.rejectNullKey(key);
        boolean[] missed = new boolean[1];
        try {
            Object object = this.internalCache.get(key, () -> {
                SimpleTimer timer;
                missed[0] = true;
                this.acquireLockFor(key);
                this.loadLock.lock();
                SimpleTimer simpleTimer = timer = this.isCollectorStatisticsEnabled() ? new SimpleTimer(CacheKeys.LOAD_TIME.getName()) : null;
                if (timer != null) {
                    timer.start();
                }
                try {
                    Object object = Objects.requireNonNull(valueLoader.get());
                    return object;
                }
                finally {
                    if (timer != null) {
                        timer.end();
                        this.collector.put();
                        this.collector.getSplits().add(timer);
                    }
                }
            });
            return (V)object;
        }
        catch (ExecutionException e) {
            throw new CacheException("Unknown failure", (Throwable)e);
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            Throwables.propagateIfInstanceOf((Throwable)cause, CacheException.class);
            throw new CacheException(cause);
        }
        finally {
            if (missed[0]) {
                this.loadLock.unlock();
                this.releaseLockFor(key);
            }
            if (this.isCollectorStatisticsEnabled()) {
                if (missed[0]) {
                    this.collector.miss();
                } else {
                    this.collector.hit();
                }
            }
        }
    }

    public void remove(@Nonnull K key) {
        this.acquireLockFor(key);
        try {
            this.internalCache.invalidate(key);
            if (this.isCollectorStatisticsEnabled()) {
                this.collector.remove();
            }
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        finally {
            this.releaseLockFor(key);
        }
    }

    public void removeAll() {
        this.removeAllLock.lock();
        try {
            this.internalCache.invalidateAll();
            this.eventLogger.info("Cache {} was flushed", (Object)this.getName());
            if (this.stacktraceLogger.isInfoEnabled()) {
                this.stacktraceLogger.info("Cache {} was flushed. Stacktrace:", (Object)this.getName(), (Object)new Exception());
            }
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        finally {
            this.removeAllLock.unlock();
        }
    }

    public V putIfAbsent(@Nonnull K key, @Nonnull V value) {
        try {
            V oldValue = this.internalCache.asMap().putIfAbsent(key, value);
            if (oldValue == null) {
                this.listenerSupport.notifyAdd(key, value);
            } else if (this.isCollectorStatisticsEnabled()) {
                this.collector.put();
            }
            return oldValue;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public boolean remove(@Nonnull K key, @Nonnull V value) {
        try {
            boolean bl = this.internalCache.asMap().remove(key, value);
            return bl;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        finally {
            if (this.isCollectorStatisticsEnabled()) {
                this.collector.remove();
            }
        }
    }

    public boolean replace(@Nonnull K key, @Nonnull V oldValue, @Nonnull V newValue) {
        try {
            return this.internalCache.asMap().replace(key, oldValue, newValue);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Nonnull
    public SortedMap<CacheStatisticsKey, java.util.function.Supplier<Long>> getStatistics() {
        if (this.isStatisticsEnabled()) {
            return DelegatingCacheStatistics.toStatistics(this.internalCache);
        }
        return ImmutableSortedMap.of();
    }

    public void clear() {
        this.removeAll();
    }

    private boolean isCollectorStatisticsEnabled() {
        return this.collector.isEnabled();
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.settings.getStatisticsEnabled();
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof DelegatingCache) {
            DelegatingCache otherDelegatingCache = (DelegatingCache)other;
            if (this.internalCache.equals(otherDelegatingCache.internalCache)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 3 + this.internalCache.hashCode();
    }

    public void addListener(@Nonnull CacheEntryListener<K, V> listener, boolean includeValues) {
        this.listenerSupport.add(listener, includeValues);
    }

    public void removeListener(@Nonnull CacheEntryListener<K, V> listener) {
        this.listenerSupport.remove(listener);
    }

    void rejectNullKey(K key) {
        if (key == null) {
            throw new CacheException((Throwable)new NullPointerException("Null keys are not supported"));
        }
    }

    private ReentrantLock acquireLockFor(@Nonnull K key) {
        ReentrantLock barrier = new ReentrantLock();
        barrier.lock();
        ReentrantLock existing;
        while ((existing = this.barriers.putIfAbsent(key, barrier)) != null) {
            if (existing.isHeldByCurrentThread()) {
                existing.lock();
                return existing;
            }
            existing.lock();
            existing.unlock();
        }
        return barrier;
    }

    private void releaseLockFor(K key) {
        ReentrantLock barrier = (ReentrantLock)this.barriers.get(key);
        if (barrier != null && barrier.isHeldByCurrentThread()) {
            if (barrier.getHoldCount() <= 1) {
                this.barriers.remove(key);
            }
            barrier.unlock();
        }
    }

    public static class DefaultCreateFunction
    implements CreateFunction {
        @Override
        public <K, V> DelegatingCache<K, V> create(com.google.common.cache.Cache<K, V> internalCache, String name, CacheSettings settings, CacheLoader<K, V> cacheLoader) {
            return new DelegatingCache<K, V>(internalCache, name, settings, cacheLoader);
        }
    }

    public static interface CreateFunction {
        public <K, V> DelegatingCache<K, V> create(com.google.common.cache.Cache<K, V> var1, String var2, CacheSettings var3, CacheLoader<K, V> var4);
    }

    protected static class DelegatingRemovalListener<K, V>
    implements RemovalListener<K, V> {
        private DelegatingCache<K, V> cache;

        protected DelegatingRemovalListener() {
        }

        protected void onSupply(K key, V value) {
            ((DelegatingCache)this.cache).listenerSupport.notifyAdd(key, value);
        }

        public void onRemoval(@Nonnull RemovalNotification<K, V> notification) {
            switch (notification.getCause()) {
                case COLLECTED: 
                case EXPIRED: 
                case SIZE: {
                    ((DelegatingCache)this.cache).listenerSupport.notifyEvict(notification.getKey(), notification.getValue());
                    break;
                }
                case EXPLICIT: {
                    ((DelegatingCache)this.cache).listenerSupport.notifyRemove(notification.getKey(), notification.getValue());
                    break;
                }
                case REPLACED: {
                    Object key = Objects.requireNonNull(notification.getKey());
                    ((DelegatingCache)this.cache).listenerSupport.notifyUpdate(key, ((DelegatingCache)this.cache).internalCache.getIfPresent(key), notification.getValue());
                }
            }
        }

        public void setCache(DelegatingCache<K, V> cache) {
            this.cache = cache;
        }
    }
}

