package com.atlassian.cache.hazelcast;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * An implementation of {@link HazelcastNameFactory} which applies the legacy prefixes to the Hazelcast objects.
 * This is the default implementation used by {@link HazelcastCacheManager}.
 *
 * @since 5.4.0
 */
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class LegacyPrefixedNameFactory implements HazelcastNameFactory {
    static final String PREFIX = "atlassian-cache.";
    static final String PREFIX_CACHE_REFERENCE = PREFIX + "CacheReference.";
    static final String PREFIX_CACHE = PREFIX + "Cache.";
    static final String CACHE_VERSION_PREFIX = "_CACHE_VERSION.";

    @Override
    public String getCacheInvalidationTopicName(String cacheName) {
        return PREFIX_CACHE + cacheName;
    }

    @Override
    public String getCachedReferenceInvalidationTopicName(String cacheName) {
        return PREFIX_CACHE_REFERENCE + cacheName;
    }

    @Override
    public String getCacheIMapName(String cacheName) {
        return PREFIX_CACHE + cacheName;
    }

    @Override
    public String getCachedReferenceIMapName(String cacheName) {
        return PREFIX_CACHE_REFERENCE + cacheName;
    }

    @Override
    public String getCacheVersionCounterName(String cacheName) {
        return CACHE_VERSION_PREFIX + cacheName;
    }
}
