package com.atlassian.cache.hazelcast;

import java.util.Map;

import com.hazelcast.map.EntryProcessor;

class IncrementVersionEntryProcessor<K> implements EntryProcessor<K, Long, Long>
{
    private static final IncrementVersionEntryProcessor<Object> INSTANCE =
            new IncrementVersionEntryProcessor<Object>();

    protected static <T> IncrementVersionEntryProcessor<T> getInstance()
    {
        //noinspection unchecked
        return (IncrementVersionEntryProcessor<T>) INSTANCE;
    }

    private IncrementVersionEntryProcessor()
    {
    }

    @Override
    public Long process(Map.Entry<K, Long> entry)
    {
        Long value = entry.getValue();
        value = value == null ? 1L : value + 1L;
        entry.setValue(value);
        return value;
    }
}
